/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.VoidTotem;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.UsedTotemTrigger;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModDataGeneration {
    private static final Logger DATAGEN_LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final ITag.INamedTag<Item> CURIOS_CHARM = ModDataGeneration.modTag("charm", "curios");

    private static ITag.INamedTag<Item> modTag(String name, String modID) {
        return ItemTags.func_199901_a((String)(modID + ":" + name));
    }

    public static class LootTableGen
    extends LootTableProvider {
        private final DataGenerator generator;

        public LootTableGen(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
            this.generator = dataGeneratorIn;
        }

        public void func_200398_a(DirectoryCache cache) {
            HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
            LootPool.Builder voidtotem_loot_builder = LootPool.func_216096_a().name("main").func_212840_b_(RandomChance.func_216004_a((float)0.33f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)VoidTotem.VOID_TOTEM_ITEM.get())).func_216086_a(1));
            tables.put(ModConstants.LOCATION_END_CITY_TREASURE_INJECTION, LootTable.func_216119_b().func_216040_a(voidtotem_loot_builder).func_216038_b());
            this.writeLootTables(cache, tables);
        }

        private void writeLootTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
            Path outputFolder = this.generator.func_200391_b();
            tables.forEach((key, lootTable) -> {
                Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
                try {
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
                    DATAGEN_LOGGER.debug("Creating loot table {}", (Object)key.func_110623_a());
                }
                catch (IOException e) {
                    DATAGEN_LOGGER.error("Couldn't create loot table {}", (Object)key.func_110623_a(), (Object)e);
                }
            });
        }
    }

    public static class AdvancementGen
    extends AdvancementProvider {
        private final DataGenerator generator;

        public AdvancementGen(DataGenerator generatorIn) {
            super(generatorIn);
            this.generator = generatorIn;
        }

        private void registerAdvancements(Consumer<Advancement> consumer) {
            Advancement.Builder.func_200278_a().func_203905_a(Advancement.Builder.func_200278_a().func_192056_a(new ResourceLocation("adventure/totem_of_undying"))).func_203902_a((IItemProvider)VoidTotem.VOID_TOTEM_ITEM.get(), (ITextComponent)new TranslationTextComponent("advancements.voidtotem.adventure.totem_of_void_undying.title"), (ITextComponent)new TranslationTextComponent("advancements.voidtotem.adventure.totem_of_void_undying.description"), (ResourceLocation)null, FrameType.GOAL, true, true, false).func_200275_a("used_totem", (ICriterionInstance)UsedTotemTrigger.Instance.func_203941_a((IItemProvider)((IItemProvider)VoidTotem.VOID_TOTEM_ITEM.get()))).func_203904_a(consumer, "adventure/totem_of_void_undying");
        }

        public void func_200398_a(DirectoryCache cache) throws IOException {
            Path outputFolder = this.generator.func_200391_b();
            Consumer<Advancement> consumer = advancement -> {
                Path path = outputFolder.resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
                try {
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path);
                    DATAGEN_LOGGER.debug("Creating advancement {}", (Object)advancement.func_192067_g());
                }
                catch (IOException e) {
                    DATAGEN_LOGGER.error("Couldn't create advancement {}", (Object)path, (Object)e);
                }
            };
            this.registerAdvancements(consumer);
        }
    }

    public static final class ItemTagsGen
    extends ItemTagsProvider {
        public ItemTagsGen(DataGenerator gen, BlockTagsProvider provider, String modID, ExistingFileHelper existingFileHelper) {
            super(gen, provider, modID, existingFileHelper);
        }

        protected void func_200432_c() {
            this.func_240522_a_(CURIOS_CHARM).func_240534_a_((Object[])new Item[]{(Item)VoidTotem.VOID_TOTEM_ITEM.get()}).func_240534_a_((Object[])new Item[]{Items.field_190929_cY});
        }
    }

    public static final class BlockTagsGen
    extends BlockTagsProvider {
        public BlockTagsGen(DataGenerator generatorIn, String modId, ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }
    }

    public static final class RecipeGen
    extends RecipeProvider {
        public RecipeGen(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)VoidTotem.VOID_TOTEM_ITEM.get())).func_200472_a("cec").func_200472_a("dtd").func_200472_a(" e ").func_200462_a(Character.valueOf('c'), (IItemProvider)Items.field_185161_cS).func_200462_a(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('d'), (IItemProvider)Items.field_151166_bC).func_200462_a(Character.valueOf('t'), (IItemProvider)Items.field_190929_cY).func_200465_a("has_chorus_fruit", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_185161_cS)).func_200465_a("has_ender_eye", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151061_bv)).func_200465_a("has_emerald", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151166_bC)).func_200465_a("has_totem", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_190929_cY)).func_200464_a(consumer);
        }
    }

    public static final class ItemModelGen
    extends ItemModelProvider {
        private final Set<Item> blacklist = new HashSet<Item>();

        public ItemModelGen(DataGenerator gen, String modid, ExistingFileHelper existingFileHelper) {
            super(gen, modid, existingFileHelper);
        }

        protected void registerModels() {
            for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null || !"voidtotem".equals(id.func_110624_b()) || this.blacklist.contains(item)) continue;
                if (item instanceof BlockItem) {
                    return;
                }
                this.defaultItem(id, item);
            }
        }

        protected void defaultItem(ResourceLocation id, Item item) {
            ((ItemModelBuilder)this.withExistingParent(id.func_110623_a(), "item/generated")).texture("layer0", new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a()));
            DATAGEN_LOGGER.debug("Generated item model for: " + item.getRegistryName());
        }
    }

    public static final class LanguageGen
    extends LanguageProvider {
        public LanguageGen(DataGenerator gen, String modid, String locale) {
            super(gen, "voidtotem", locale);
        }

        protected void addTranslations() {
            String locale;
            switch (locale = this.func_200397_b().replace("Languages: ", "")) {
                case "de_de": {
                    this.add("_comment", "Translation (de_de) by Affehund");
                    this.add((Item)VoidTotem.VOID_TOTEM_ITEM.get(), "Totem der Unsterblichkeit in der Leere");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Lege diese Totem in deine Haupt-/Nebenhand, um zu verhindern, dass du stirbst, wenn du in die Leere f\u00e4llst.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Post mortem 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Benutze ein Totem der Unsterblichkeit in der Leere, um dem Tod, wenn du in die Leere f\u00e4llst, von der Schippe zu springen");
                    break;
                }
                case "en_us": {
                    this.add("_comment", "Translation (en_us) by Affehund");
                    this.add((Item)VoidTotem.VOID_TOTEM_ITEM.get(), "Totem of Void Undying");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Put this totem in your main-/offhand to prevent dying if you fall in the void.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Postmortal 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Use a Totem of Void Undying to cheat death when falling in the void");
                }
            }
        }
    }
}

