/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.core.ModDataGeneration;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.core.VoidTotemConfig;
import com.affehund.voidtotem.core.network.PacketHandler;
import com.affehund.voidtotem.core.network.TotemEffectPacket;
import java.util.ArrayList;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="voidtotem")
public class VoidTotem {
    public static final Logger LOGGER = LogManager.getLogger((String)"Void Totem");
    public static VoidTotem INSTANCE;
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    final IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
    public static final DeferredRegister<Item> ITEMS;
    public static final RegistryObject<Item> VOID_TOTEM_ITEM;

    public VoidTotem() {
        INSTANCE = this;
        LOGGER.debug("Loading up {}!", (Object)"Void Totem");
        this.modEventBus.addListener(this::gatherData);
        this.modEventBus.addListener(this::enqueueIMC);
        ITEMS.register(this.modEventBus);
        this.forgeEventBus.register((Object)this);
        this.forgeEventBus.addListener(this::livingHurt);
        this.forgeEventBus.addListener(this::livingFall);
        this.forgeEventBus.addListener(this::playerTick);
        PacketHandler.registerMessages();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, VoidTotemConfig.COMMON_CONFIG_SPEC, "voidtotem-common.toml");
    }

    @SubscribeEvent
    public void loadLootTables(LootTableLoadEvent event) {
        if (((Boolean)VoidTotemConfig.COMMON_CONFIG.ADD_END_CITY_TREASURE.get()).booleanValue() && event.getName().equals((Object)ModConstants.LOCATION_END_CITY_TREASURE)) {
            LOGGER.debug("Injecting loottable {} from {}", (Object)ModConstants.LOCATION_END_CITY_TREASURE.toString(), (Object)"voidtotem");
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)ModConstants.LOCATION_END_CITY_TREASURE_INJECTION)).name("voidtotem_injection").func_216044_b());
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (ModUtils.isModLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
            LOGGER.debug("Enqueued IMC to {}", (Object)"curios");
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new ModDataGeneration.RecipeGen(generator));
            ModDataGeneration.BlockTagsGen blockTagsProvider = new ModDataGeneration.BlockTagsGen(generator, "voidtotem", existingFileHelper);
            generator.func_200390_a((IDataProvider)new ModDataGeneration.ItemTagsGen(generator, blockTagsProvider, "voidtotem", existingFileHelper));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.AdvancementGen(generator));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.LootTableGen(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new ModDataGeneration.LanguageGen(generator, "voidtotem", "de_de"));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.LanguageGen(generator, "voidtotem", "en_us"));
            generator.func_200390_a((IDataProvider)new ModDataGeneration.ItemModelGen(generator, "voidtotem", existingFileHelper));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == VOID_TOTEM_ITEM.get() && ((Boolean)VoidTotemConfig.COMMON_CONFIG.SHOW_TOTEM_TOOLTIP.get()).booleanValue()) {
            event.getToolTip().add(new TranslationTextComponent("tooltip.voidtotem.totem_of_void_undying").func_240699_a_(TextFormatting.GREEN));
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && event.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            BlockPos pos = player.func_233580_cy_();
            long lastPosLong = player.getPersistentData().func_74763_f("voidtotem_last_block_pos");
            BlockPos lastPos = BlockPos.func_218283_e((long)lastPosLong);
            if (player.field_70170_p.func_180495_p(pos.func_177977_b()).func_200132_m() && !lastPos.equals((Object)pos)) {
                player.getPersistentData().func_74772_a("voidtotem_last_block_pos", pos.func_218275_a());
            }
            if (player.getPersistentData().func_74767_n("voidtotem_living_falling")) {
                player.field_71135_a.field_147365_f = 0;
                if (player.func_70090_H() || player.field_71075_bZ.field_75100_b || player.field_71075_bZ.field_75101_c || player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_196553_aF) {
                    player.getPersistentData().func_74757_a("voidtotem_living_falling", false);
                }
            }
        }
    }

    private void livingHurt(LivingHurtEvent event) {
        if (event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        if (((ArrayList)VoidTotemConfig.COMMON_CONFIG.BLACKLISTED_DIMENSIONS.get()).contains(event.getEntityLiving().field_70170_p.func_234923_W_().func_240901_a_().toString())) {
            return;
        }
        if (event.getSource() != DamageSource.field_76380_i) {
            return;
        }
        if (event.getEntityLiving().func_226278_cu_() > -64.0) {
            return;
        }
        if (event.getAmount() < event.getEntityLiving().func_110143_aJ()) {
            return;
        }
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            player.field_71135_a.field_147365_f = 0;
            ItemStack itemstack = null;
            boolean foundValidStack = false;
            if (!((Boolean)VoidTotemConfig.COMMON_CONFIG.NEEDS_TOTEM.get()).booleanValue()) {
                itemstack = ItemStack.field_190927_a;
                foundValidStack = true;
            } else if (((Boolean)VoidTotemConfig.COMMON_CONFIG.USE_TOTEM_FROM_INVENTORY.get()).booleanValue()) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (!VoidTotem.isVoidTotemOrTotem(stack)) continue;
                    itemstack = VoidTotem.copyAndRemoveItemStack(stack, player);
                    foundValidStack = true;
                    break;
                }
            } else {
                if (ModUtils.isModLoaded("curios")) {
                    ItemStack curiosVanillaTotemStack;
                    ItemStack curiosVoidTotemStack = ModUtils.findCuriosItem((Item)VOID_TOTEM_ITEM.get(), (LivingEntity)player);
                    ItemStack itemStack = curiosVanillaTotemStack = (Boolean)VoidTotemConfig.COMMON_CONFIG.ALLOW_TOTEM_OF_UNDYING.get() != false ? ModUtils.findCuriosItem(Items.field_190929_cY, (LivingEntity)player) : ItemStack.field_190927_a;
                    if (curiosVoidTotemStack != ItemStack.field_190927_a) {
                        itemstack = VoidTotem.copyAndRemoveItemStack(curiosVoidTotemStack, player);
                        foundValidStack = true;
                    } else if (curiosVanillaTotemStack != ItemStack.field_190927_a) {
                        itemstack = VoidTotem.copyAndRemoveItemStack(curiosVanillaTotemStack, player);
                        foundValidStack = true;
                    }
                }
                if (!foundValidStack) {
                    for (ItemStack hand : Hand.values()) {
                        ItemStack stack = player.func_184586_b((Hand)hand);
                        if (!VoidTotem.isVoidTotemOrTotem(stack)) continue;
                        itemstack = VoidTotem.copyAndRemoveItemStack(stack, player);
                        foundValidStack = true;
                        break;
                    }
                }
            }
            if (itemstack != null && foundValidStack) {
                if (player.field_71135_a.field_184362_y != null) {
                    return;
                }
                if (player.func_184207_aI()) {
                    player.func_184226_ay();
                }
                player.func_184210_p();
                long lastBlockPos = player.getPersistentData().func_74763_f("voidtotem_last_block_pos");
                BlockPos teleportPos = BlockPos.func_218283_e((long)lastBlockPos);
                boolean teleportedToBlock = false;
                for (int i = 0; i < 16; ++i) {
                    double z;
                    double y;
                    double x = (double)teleportPos.func_177958_n() + (player.func_70681_au().nextDouble() - 0.5) * 4.0;
                    if (!player.func_213373_a(x, y = MathHelper.func_151237_a((double)(player.func_70681_au().nextInt() * player.field_70170_p.func_217301_I()), (double)0.0, (double)(player.field_70170_p.func_217301_I() - 1)), z = (double)teleportPos.func_177952_p() + (player.func_70681_au().nextDouble() - 0.5) * 4.0, true)) continue;
                    teleportedToBlock = true;
                    break;
                }
                if (!teleportedToBlock) {
                    player.func_70634_a((double)teleportPos.func_177958_n(), (double)((Integer)VoidTotemConfig.COMMON_CONFIG.TELEPORT_HEIGHT.get()).intValue(), (double)teleportPos.func_177952_p());
                    player.field_71135_a.field_147365_f = 0;
                }
                event.setCanceled(true);
                player.getPersistentData().func_74757_a("voidtotem_living_falling", true);
                PacketHandler.sendToPlayer(new TotemEffectPacket(itemstack, (Entity)player), player);
                PacketHandler.sendToAllTracking(new TotemEffectPacket(itemstack, (Entity)player), player);
            }
        }
    }

    public static boolean isVoidTotemOrTotem(ItemStack stack) {
        boolean isTotemOfUndying;
        boolean isVoidTotem;
        Item item = stack.func_77973_b();
        boolean bl = isVoidTotem = item == VOID_TOTEM_ITEM.get();
        boolean bl2 = ((Boolean)VoidTotemConfig.COMMON_CONFIG.ALLOW_TOTEM_OF_UNDYING.get()).booleanValue() ? item == Items.field_190929_cY : (isTotemOfUndying = false);
        return isVoidTotem || isTotemOfUndying;
    }

    private static ItemStack copyAndRemoveItemStack(ItemStack itemStack, ServerPlayerEntity player) {
        ItemStack itemStackCopy = itemStack.func_77946_l();
        if (!itemStack.func_190926_b()) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)itemStack.func_77973_b()));
            CriteriaTriggers.field_193130_A.func_193187_a(player, itemStack);
        }
        itemStack.func_190918_g(1);
        return itemStackCopy;
    }

    private void livingFall(LivingFallEvent event) {
        ServerPlayerEntity player;
        if (event.getEntity() instanceof ServerPlayerEntity && (player = (ServerPlayerEntity)event.getEntity()).getPersistentData().func_74767_n("voidtotem_living_falling")) {
            player.field_71135_a.field_147365_f = 0;
            event.setDamageMultiplier(0.0f);
            player.getPersistentData().func_74757_a("voidtotem_living_falling", false);
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playActivateAnimation(ItemStack stack, Entity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71452_i.func_199281_a(entity, (IParticleData)ParticleTypes.field_197604_O, 30);
        mc.field_71441_e.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_191263_gW, entity.func_184176_by(), 1.0f, 1.0f, false);
        if (entity == mc.field_71439_g) {
            mc.field_71460_t.func_190565_a(stack);
        }
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"voidtotem");
        VOID_TOTEM_ITEM = ITEMS.register("totem_of_void_undying", () -> new Item(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78037_j).func_208103_a(Rarity.UNCOMMON)));
    }
}

