/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.VoidTotem;
import java.util.ArrayList;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="voidtotem", bus=Mod.EventBusSubscriber.Bus.MOD)
public class VoidTotemConfig {
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    public static final VoidCommonConfig COMMON_CONFIG;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        VoidTotem.LOGGER.info("Loaded {} config file from {}", (Object)event.getConfig().getFileName(), (Object)"voidtotem");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(VoidCommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON_CONFIG = (VoidCommonConfig)specPair.getLeft();
    }

    public static class VoidCommonConfig {
        public final ForgeConfigSpec.BooleanValue ADD_END_CITY_TREASURE;
        public final ForgeConfigSpec.BooleanValue ALLOW_TOTEM_OF_UNDYING;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> BLACKLISTED_DIMENSIONS;
        public final ForgeConfigSpec.BooleanValue NEEDS_TOTEM;
        public final ForgeConfigSpec.BooleanValue SHOW_TOTEM_TOOLTIP;
        public final ForgeConfigSpec.IntValue TELEPORT_HEIGHT;
        public final ForgeConfigSpec.BooleanValue USE_TOTEM_FROM_INVENTORY;

        public VoidCommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Void Totem Common Config").push("general");
            this.ADD_END_CITY_TREASURE = builder.comment("This sets whether the void totem will be added to the end city treasure.").define("add_end_city_treasure", true);
            this.ALLOW_TOTEM_OF_UNDYING = builder.comment("This sets whether the totem of undying will prevent death when falling into the void.").define("allow_totem_of_undying", false);
            this.BLACKLISTED_DIMENSIONS = builder.comment("This adds dimensions to a blacklist where you die if you fall into the void. Example: \"minecraft:overworld\".").define("blacklisted_dimensions", new ArrayList());
            this.NEEDS_TOTEM = builder.comment("This sets whether you need a totem to prevent death when falling into the void.").define("needs_totem", true);
            this.SHOW_TOTEM_TOOLTIP = builder.comment("This sets whether a tooltip is shown on the totem.").define("show_totem_tooltip", true);
            this.TELEPORT_HEIGHT = builder.comment("This sets the height you will be teleported when you can't be placed on a block.").defineInRange("teleport_height", 320, 256, 2048);
            this.USE_TOTEM_FROM_INVENTORY = builder.comment("This sets whether the totem prevents you from dying in the void if there is a totem anywhere in your inventory. If false the totem has to been in the main-/offhand or in the charm slot (curios api has to be installed).").define("use_totem_from_inventory", false);
            builder.pop();
        }
    }
}

