/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.atesab.customcursormod.common.CursorMod;
import fr.atesab.customcursormod.common.config.CursorConfig;
import fr.atesab.customcursormod.common.cursor.CursorType;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean dynamicCursor = true;
    public boolean clickAnimation = true;
    private File storage;

    public boolean isClickAnimation() {
        return this.clickAnimation;
    }

    public boolean isDynamicCursor() {
        return this.dynamicCursor;
    }

    public void save() {
        if (this.storage != null) {
            ConfigurationStore store = new ConfigurationStore(this);
            try (FileWriter w = new FileWriter(this.storage);){
                GSON.toJson((Object)store, (Appendable)w);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setClickAnimation(boolean clickAnimation) {
        this.clickAnimation = clickAnimation;
    }

    public void setDynamicCursor(boolean dynamicCursor) {
        this.dynamicCursor = dynamicCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(File path) {
        this.storage = path;
        try (FileReader r = new FileReader(this.storage);){
            ConfigurationStore store = (ConfigurationStore)GSON.fromJson((Reader)r, ConfigurationStore.class);
            this.clickAnimation = store.clickAnimation;
            this.dynamicCursor = store.dynamicCursor;
            Map<CursorType, CursorConfig> cursors = CursorMod.getInstance().getCursors();
            for (CursorType type : cursors.keySet()) {
                try {
                    CursorConfig.CursorConfigStore cstore = store.cursors.get(type.getConfigName());
                    CursorConfig old = cursors.put(type, CursorConfig.read(cstore, type.getDefaultConfig()));
                    if (old == null) continue;
                    old.freeCursor();
                }
                catch (Exception e) {
                    CursorMod.logger.warning("Can't load the cursor \"" + type.getConfigName() + "\" : " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.save();
        }
    }

    static class ConfigurationStore {
        public boolean dynamicCursor = true;
        public boolean clickAnimation = true;
        public Map<String, CursorConfig.CursorConfigStore> cursors = new HashMap<String, CursorConfig.CursorConfigStore>();

        private ConfigurationStore(Configuration current) {
            this();
            this.dynamicCursor = current.dynamicCursor;
            this.clickAnimation = current.clickAnimation;
            Map<CursorType, CursorConfig> currentCursors = CursorMod.getInstance().getCursors();
            for (Map.Entry<CursorType, CursorConfig> e : currentCursors.entrySet()) {
                CursorType type = e.getKey();
                CursorConfig cfg = e.getValue();
                this.cursors.put(type.getConfigName(), cfg.write());
            }
        }

        private ConfigurationStore() {
        }
    }
}

