/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.common.gui;

import fr.atesab.customcursormod.common.CursorMod;
import fr.atesab.customcursormod.common.config.Configuration;
import fr.atesab.customcursormod.common.config.CursorConfig;
import fr.atesab.customcursormod.common.cursor.CursorType;
import fr.atesab.customcursormod.common.gui.GuiConfigCursorMod;
import fr.atesab.customcursormod.common.gui.GuiCursorConfig;
import fr.atesab.customcursormod.common.handler.CommonButton;
import fr.atesab.customcursormod.common.handler.CommonMatrixStack;
import fr.atesab.customcursormod.common.handler.CommonScreen;
import fr.atesab.customcursormod.common.handler.GuiUtils;
import fr.atesab.customcursormod.common.handler.TranslationCommonText;
import fr.atesab.customcursormod.common.utils.I18n;

public class GuiConfig
extends CommonScreen.ScreenListener {
    public static CommonScreen create(CommonScreen parent) {
        return CommonScreen.create(parent, TranslationCommonText.create("cursormod.gui.config", new Object[0]), new GuiConfig());
    }

    private GuiConfig() {
    }

    @Override
    public void init() {
        CursorMod mod = CursorMod.getInstance();
        Configuration cfg = mod.getConfig();
        CommonScreen screen = this.getScreen();
        screen.addChildren(CommonButton.create(TranslationCommonText.create("menu.options", new Object[0]), this.width / 2 - 100, this.height / 2 + 24, 200, 20, b -> {
            if (cfg.dynamicCursor) {
                GuiConfigCursorMod.create(screen).displayScreen();
            } else {
                CursorConfig ccfg = mod.getCursors().get(CursorType.POINTER);
                GuiCursorConfig.create(screen, CursorType.POINTER, ccfg, cursorConfig -> mod.replaceCursor(CursorType.POINTER, (CursorConfig)cursorConfig)).displayScreen();
            }
        }));
        screen.addChildren(GuiUtils.get().createBooleanButton(TranslationCommonText.create("cursormod.config.dynCursor", new Object[0]), this.width / 2 - 100, this.height / 2 - 24, 200, 20, cfg::isDynamicCursor, cfg::setDynamicCursor));
        screen.addChildren(GuiUtils.get().createBooleanButton(TranslationCommonText.create("cursormod.config.clickAnim", new Object[0]), this.width / 2 - 100, this.height / 2, 200, 20, cfg::isClickAnimation, cfg::setClickAnimation));
        screen.addChildren(CommonButton.create(TranslationCommonText.create("gui.done", new Object[0]), this.width / 2 - 100, this.height / 2 + 48, 200, 20, b -> {
            mod.saveConfig();
            screen.getParent().displayScreen();
        }));
        super.init();
    }

    @Override
    public void render(CommonMatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.getScreen().renderDefaultBackground(stack);
        this.getScreen().drawCenterString(stack, "Custom Cursor Mod", (float)this.width / 2.0f, (float)this.height / 2.0f - 60.0f, -26300, 2.5f);
        this.getScreen().drawRightString(stack, CursorMod.getInstance().getType().toString() + " - 1.3.0", this.width - 5, this.height - GuiUtils.get().fontHeight() * 3 - 9, -1);
        this.getScreen().drawRightString(stack, I18n.get("cursormod.licence", "GNU GPL 3"), this.width - 5, this.height - GuiUtils.get().fontHeight() * 2 - 7, -1);
        this.getScreen().drawRightString(stack, I18n.get("cursormod.authors", "ATE47, KevinFernandezDominguez"), this.width - 5, this.height - GuiUtils.get().fontHeight() - 5, -1);
        super.render(stack, mouseX, mouseY, partialTicks);
    }
}

