/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.dynamicsf.config;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.andre111.dynamicsf.config.ConfigData;

public class Config {
    private static Gson gson = new Gson();
    private static ConfigData data = new ConfigData();

    public static ConfigData getData() {
        return data;
    }

    public static void loadData() {
        File file = Config.getConfigFile();
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                data = (ConfigData)gson.fromJson((Reader)reader, ConfigData.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveData() {
        File file = Config.getConfigFile();
        if (!file.exists()) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            gson.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getConfigFile() {
        return new File("./config/dynamicsf/config.json");
    }
}

