/*
 * Decompiled with CFR 0.152.
 */
package furgl.hideArmor.config;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import furgl.hideArmor.utils.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import net.minecraft.class_1304;
import net.minecraft.class_3518;

public class Config {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private static final String FILE = "./config/hideArmor.cfg";
    private static File file;
    public static HashMap<class_1304, Boolean> hideYourArmor;
    public static HashMap<class_1304, Boolean> hideOtherPlayerArmor;
    public static boolean expandedGui;
    public static boolean showGuiButton;
    public static int guiButtonXOffset;
    public static int guiButtonYOffset;

    public static void init() {
        try {
            file = new File(FILE);
            if (!file.exists()) {
                file.createNewFile();
            } else {
                Config.readFromFile();
            }
            Config.writeToFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readFromFile() {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            JsonObject parser = class_3518.method_15255((Reader)reader);
            JsonElement element = parser.get("Show gui button");
            showGuiButton = element.getAsBoolean();
            element = parser.get("Gui button X offset");
            guiButtonXOffset = element.getAsInt();
            element = parser.get("Gui button Y offset");
            guiButtonYOffset = element.getAsInt();
            element = parser.get("Gui opened");
            expandedGui = element.getAsBoolean();
            for (class_1304 slot : Utils.ARMOR_SLOTS) {
                element = parser.get("Hide your armor in slot: " + slot);
                boolean hide = element == null ? false : element.getAsBoolean();
                hideYourArmor.put(slot, hide);
                element = parser.get("Hide other players armor in slot: " + slot);
                hide = element == null ? false : element.getAsBoolean();
                hideOtherPlayerArmor.put(slot, hide);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            JsonObject obj = new JsonObject();
            obj.addProperty("Show gui button", Boolean.valueOf(showGuiButton));
            obj.addProperty("Gui button X offset", (Number)guiButtonXOffset);
            obj.addProperty("Gui button Y offset", (Number)guiButtonYOffset);
            obj.addProperty("Gui opened", Boolean.valueOf(expandedGui));
            for (class_1304 slot : Utils.ARMOR_SLOTS) {
                obj.addProperty("Hide your armor in slot: " + slot, hideYourArmor.get(slot));
                obj.addProperty("Hide other players armor in slot: " + slot, hideOtherPlayerArmor.get(slot));
            }
            writer.write(GSON.toJson((JsonElement)obj));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        hideYourArmor = Maps.newHashMap();
        hideOtherPlayerArmor = Maps.newHashMap();
        showGuiButton = true;
        for (class_1304 slot : Utils.ARMOR_SLOTS) {
            hideYourArmor.put(slot, false);
            hideOtherPlayerArmor.put(slot, false);
        }
    }
}

