/*
 * Decompiled with CFR 0.152.
 */
package einstein.einsteins_library.util;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.DesertVillagePools;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.SavannaVillagePools;
import net.minecraft.data.worldgen.SnowyVillagePools;
import net.minecraft.data.worldgen.TaigaVillagePools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.behavior.GiveGiftToHero;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.decoration.Motive;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="einsteins_library", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistryHandler {
    public static <T extends Item> T registerItem(String modid, String name, T item) {
        item.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.ITEMS.register(item);
        return item;
    }

    public static <T extends Item> T registerItem(String modid, String dependencyModid, String name, T item) {
        item.setRegistryName(new ResourceLocation(modid, name));
        if (ModList.get().isLoaded(dependencyModid)) {
            ForgeRegistries.ITEMS.register(item);
        }
        return item;
    }

    public static <T extends Block> T registerBlock(String modid, String name, T block, CreativeModeTab tab) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        block.setRegistryName(resource);
        BlockItem item = new BlockItem(block, new Item.Properties().m_41491_(tab));
        item.setRegistryName(resource);
        ForgeRegistries.BLOCKS.register(block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return block;
    }

    public static <T extends Block> T registerBlock(String modid, String name, T block) {
        block.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.BLOCKS.register(block);
        return block;
    }

    public static <T extends Block> T registerBlock(String modid, String dependencyModid, String name, T block, CreativeModeTab tab) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        block.setRegistryName(resource);
        BlockItem item = new BlockItem(block, new Item.Properties().m_41491_(tab));
        item.setRegistryName(resource);
        if (ModList.get().isLoaded(dependencyModid)) {
            ForgeRegistries.BLOCKS.register(block);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        }
        return block;
    }

    public static <T extends Block> T registerBlock(String modid, String dependencyModid, String name, T block) {
        block.setRegistryName(new ResourceLocation(modid, name));
        if (ModList.get().isLoaded(dependencyModid)) {
            ForgeRegistries.BLOCKS.register(block);
        }
        return block;
    }

    public static <T extends Entity> EntityType<T> registerEntity(String modid, String name, EntityType.Builder<T> builder) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        EntityType entity = builder.m_20712_(resource.toString());
        entity.setRegistryName(resource);
        ForgeRegistries.ENTITIES.register((IForgeRegistryEntry)entity);
        return entity;
    }

    public static SoundEvent registerSound(String modid, String name) {
        ResourceLocation resource = new ResourceLocation(modid, name);
        SoundEvent soundEvent = new SoundEvent(resource);
        soundEvent.setRegistryName(resource);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)soundEvent);
        return soundEvent;
    }

    public static SoundType registerSoundType(float volume, float pitch, SoundEvent breakSound, SoundEvent stepSound, SoundEvent placeSound, SoundEvent hitSound, SoundEvent fallSound) {
        SoundType soundType = new SoundType(volume, pitch, breakSound, stepSound, placeSound, hitSound, fallSound);
        return soundType;
    }

    public static Enchantment registerEnchantment(String modid, String name, Enchantment enchantment) {
        enchantment.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.ENCHANTMENTS.register((IForgeRegistryEntry)enchantment);
        return enchantment;
    }

    public static BannerPattern registerBannerPattern(String modid, String name, boolean hasPatternItem) {
        return BannerPattern.create((String)name.toUpperCase(), (String)name, (String)(modid + "." + name), (boolean)hasPatternItem);
    }

    public static MobEffect registerMobEffect(String modid, String name, MobEffect mobEffect) {
        mobEffect.setRegistryName(modid, name);
        ForgeRegistries.MOB_EFFECTS.register((IForgeRegistryEntry)mobEffect);
        return mobEffect;
    }

    public static Potion registerPotion(String modid, String name, Potion potion) {
        potion.setRegistryName(modid, name);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)potion);
        return potion;
    }

    public static SimpleParticleType registerParticle(String modid, String name, boolean alwaysShow) {
        SimpleParticleType particleType = new SimpleParticleType(alwaysShow);
        particleType.setRegistryName(modid, name);
        ForgeRegistries.PARTICLE_TYPES.register((IForgeRegistryEntry)particleType);
        return particleType;
    }

    public static PoiType registerPOI(String modid, String name, Block block) {
        PoiType poi = new PoiType(name, PoiType.m_27372_((Block)block), 1, 1);
        poi.setRegistryName(modid, name);
        ForgeRegistries.POI_TYPES.register((IForgeRegistryEntry)poi);
        return poi;
    }

    public static VillagerProfession registerProfession(String modid, String name, PoiType poi, SoundEvent workSound) {
        VillagerProfession profession = new VillagerProfession(name, poi, ImmutableSet.of(), ImmutableSet.of(), workSound);
        profession.setRegistryName(modid, name);
        ForgeRegistries.PROFESSIONS.register((IForgeRegistryEntry)profession);
        return profession;
    }

    public static VillagerProfession registerProfession(String modid, String name, PoiType poi, SoundEvent workSound, String gift) {
        VillagerProfession profession = new VillagerProfession(name, poi, ImmutableSet.of(), ImmutableSet.of(), workSound);
        profession.setRegistryName(modid, name);
        GiveGiftToHero.f_147550_.put(profession, new ResourceLocation(modid, gift));
        ForgeRegistries.PROFESSIONS.register((IForgeRegistryEntry)profession);
        return profession;
    }

    public static <T extends Fluid> T registerFluid(String modid, String name, T fluid) {
        fluid.setRegistryName(modid, name);
        ForgeRegistries.FLUIDS.register(fluid);
        return fluid;
    }

    public static ForgeFlowingFluid.Properties registerFluidProperties(String modid, String name, Supplier<FlowingFluid> still, Supplier<FlowingFluid> flowing) {
        String location = "block/" + name;
        return new ForgeFlowingFluid.Properties(still, flowing, FluidAttributes.builder((ResourceLocation)new ResourceLocation(modid, location + "_still"), (ResourceLocation)new ResourceLocation(modid, location + "_flowing")).viscosity(500).density(1400));
    }

    public static <T extends BlockEntity> BlockEntityType<T> registerBlockEntity(String modid, String name, BlockEntityType.Builder<T> builder) {
        BlockEntityType tile_entity = builder.m_58966_(null);
        tile_entity.setRegistryName(new ResourceLocation(modid, name));
        ForgeRegistries.BLOCK_ENTITIES.register((IForgeRegistryEntry)tile_entity);
        return tile_entity;
    }

    public static Motive registerPainting(String modid, String name, int width, int height) {
        Motive painting = new Motive(width, height);
        painting.setRegistryName(modid, name);
        ForgeRegistries.PAINTING_TYPES.register((IForgeRegistryEntry)painting);
        return painting;
    }

    public static <T extends AbstractContainerMenu> MenuType<T> registerMenuType(String modid, String name, MenuType.MenuSupplier<T> factory) {
        MenuType container = new MenuType(factory);
        container.setRegistryName(modid, name);
        ForgeRegistries.CONTAINERS.register((IForgeRegistryEntry)container);
        return container;
    }

    public static <T extends Recipe<?>> RecipeType<T> registerRecipeType(String modid, final String name) {
        return (RecipeType)Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation(modid, name), (Object)new RecipeType<T>(){

            public String toString() {
                return name.toString();
            }
        });
    }

    public static <T extends RecipeSerializer<? extends Recipe<?>>> T registerSerializer(String modid, String name, T serializer) {
        serializer.setRegistryName(new ResourceLocation(modid + ":" + name));
        ForgeRegistries.RECIPE_SERIALIZERS.register(serializer);
        return serializer;
    }

    public static void registerVillageBuilding(String modid, String location, int weight) {
        PlainVillagePools.m_127185_();
        DesertVillagePools.m_126860_();
        SavannaVillagePools.m_127230_();
        SnowyVillagePools.m_127233_();
        TaigaVillagePools.m_127305_();
        for (String biome : new String[]{"plains", "snowy", "savanna", "desert", "taiga"}) {
            StructureTemplatePool pattern = (StructureTemplatePool)BuiltinRegistries.f_123864_.m_7745_(new ResourceLocation("minecraft:village/" + biome + "/houses"));
            if (pattern == null) {
                return;
            }
            Function element = StructurePoolElement.m_69197_((String)(modid + ":village/" + biome + "/" + location), (StructureProcessorList)ProcessorLists.f_127204_);
            StructurePoolElement structure = (StructurePoolElement)element.apply(StructureTemplatePool.Projection.RIGID);
            try {
                String name = ASMAPI.mapField((String)"f_69250_");
                Field field = StructureTemplatePool.class.getDeclaredField(name);
                field.setAccessible(true);
                String name2 = ASMAPI.mapField((String)"f_69249_");
                Field field2 = StructureTemplatePool.class.getDeclaredField(name2);
                field2.setAccessible(true);
                List list = (List)field.get(pattern);
                for (int i = 0; i < 1; ++i) {
                    list.add(structure);
                }
                List list2 = (List)field2.get(pattern);
                list2.add(Pair.of((Object)structure, (Object)weight));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

