/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc;

import cpw.mods.modlauncher.api.INameMappingService;
import einstein.einsteins_library.util.RegistryHandler;
import einstein.jmc.JMCTab;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModClientConfigs;
import einstein.jmc.init.ModPotions;
import einstein.jmc.init.ModServerConfigs;
import einstein.jmc.util.EventHandler;
import java.lang.reflect.Field;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="jmc")
public class JustMoreCakes {
    public static final String MODID = "jmc";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final JMCTab JMC_TAB = new JMCTab(CreativeModeTab.f_40748_.length, "jmc_tab");
    public static JustMoreCakes instance;
    private Field maxItemStackSize;

    public JustMoreCakes() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModServerConfigs.SERVERSPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModClientConfigs.CLIENTSPEC);
        this.accessStackSize();
        if (this.maxItemStackSize != null) {
            modEventBus.addListener(this::resizeCakeStack);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        RegistryHandler.registerVillageBuilding((String)MODID, (String)"houses/plains_bakery_1", (int)1);
        RegistryHandler.registerVillageBuilding((String)MODID, (String)"houses/plains_bakery_2", (int)1);
        RegistryHandler.registerVillageBuilding((String)MODID, (String)"houses/desert_bakery_1", (int)1);
        RegistryHandler.registerVillageBuilding((String)MODID, (String)"houses/savanna_bakery_1", (int)1);
        RegistryHandler.registerVillageBuilding((String)MODID, (String)"houses/snowy_bakery_1", (int)1);
        RegistryHandler.registerVillageBuilding((String)MODID, (String)"houses/snowy_bakery_2", (int)1);
        RegistryHandler.registerVillageBuilding((String)MODID, (String)"houses/taiga_bakery_1", (int)1);
    }

    private void doClientStuff(ParallelDispatchEvent event) {
        event.enqueueWork(() -> ModPotions.registerPotionRecipes());
    }

    @Nullable
    private static Block missingBlock(String name) {
        switch (name) {
            case "cheese_cake": {
                return ModBlocks.CHEESECAKE;
            }
            case "triple_decker_cake": {
                return ModBlocks.THREE_TIERED_CAKE;
            }
        }
        return null;
    }

    @SubscribeEvent
    void missingItems(RegistryEvent.MissingMappings<Item> event) {
        JustMoreCakes.handleMissingMappings(event, MODID, name -> {
            switch (name) {
                case "cheese_cake": {
                    return ModBlocks.CHEESECAKE.m_5456_();
                }
                case "triple_decker_cake": {
                    return ModBlocks.THREE_TIERED_CAKE.m_5456_();
                }
            }
            Block block = JustMoreCakes.missingBlock(name);
            return block == null ? null : block.m_5456_();
        });
    }

    @SubscribeEvent
    void missingBlocks(RegistryEvent.MissingMappings<Block> event) {
        JustMoreCakes.handleMissingMappings(event, MODID, JustMoreCakes::missingBlock);
    }

    public static <T extends IForgeRegistryEntry<T>> void handleMissingMappings(RegistryEvent.MissingMappings<T> event, String modID, Function<String, T> handler) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            IForgeRegistryEntry value;
            if (!modID.equals(mapping.key.m_135827_()) || (value = (IForgeRegistryEntry)handler.apply(mapping.key.m_135815_())) == null) continue;
            mapping.remap(value);
        }
    }

    private void accessStackSize() {
        try {
            Field field = Item.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"f_41478_"));
            field.setAccessible(true);
            this.maxItemStackSize = field;
        }
        catch (Throwable t) {
            LOGGER.catching(Level.WARN, t);
        }
    }

    private void resizeCakeStack(FMLCommonSetupEvent event) {
        try {
            this.maxItemStackSize.setInt(Items.f_42502_, 64);
        }
        catch (Throwable t) {
            LOGGER.catching(Level.WARN, t);
        }
    }
}

