/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.lt.mixin;

import io.github.blobanium.lt.LoadingTimer;
import io.github.blobanium.lt.config.ConfigReader;
import io.github.blobanium.lt.resource.ResourceLoadingTimer;
import io.github.blobanium.lt.util.math.MathUtil;
import net.minecraft.class_4014;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_4014.class})
public class SimpleResourceReloadMixin {
    private static final Logger LOGGER = LogManager.getLogger((String)"Loading Timer");
    private float lastReading = 0.0f;

    @Inject(at={@At(value="TAIL")}, method={"getProgress"})
    private float getProgress(CallbackInfoReturnable<Float> ci) {
        float loadPercent = ci.getReturnValueF() * 100.0f;
        if (this.lastReading != ci.getReturnValueF()) {
            if (ConfigReader.resourceLoadPercent) {
                LOGGER.info("Resource loading progress: " + MathUtil.roundValue(loadPercent) + " %");
            }
            this.lastReading = ci.getReturnValueF();
        }
        return ci.getReturnValueF();
    }

    @Inject(at={@At(value="TAIL")}, method={"isComplete"})
    private boolean isComplete(CallbackInfoReturnable<Boolean> ci) {
        if (ci.getReturnValueZ()) {
            ResourceLoadingTimer.stopTimer();
            LoadingTimer.resourcesLoaded = true;
        }
        return ci.getReturnValueZ();
    }
}

