/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.lt.mixin;

import io.github.blobanium.lt.config.ConfigReader;
import io.github.blobanium.lt.toast.ToastExecutor;
import io.github.blobanium.lt.util.math.MathUtil;
import net.minecraft.class_3951;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3951.class})
public class WorldGenerationProgressLoggerMixin {
    private static long worldStartingTime;
    private static final Logger LOGGER;

    @Inject(at={@At(value="HEAD")}, method={"start"})
    private void start(CallbackInfo ci) {
        worldStartingTime = ConfigReader.insanePrecision ? System.nanoTime() : System.currentTimeMillis();
    }

    @Overwrite
    public void method_17671() {
        double worldTime = MathUtil.calculateMain(worldStartingTime);
        double worldTimeRounded = MathUtil.roundValue(worldTime);
        if (ConfigReader.insanePrecision) {
            double worldTimeRoundMillis = MathUtil.roundValue(worldTime * 1000.0);
            LOGGER.info("Time elapsed: " + worldTimeRoundMillis + " ms");
        } else {
            long worldTimeRoundMillis = Double.valueOf(MathUtil.roundValue(worldTime * 1000.0)).longValue();
            LOGGER.info("Time elapsed: " + worldTimeRoundMillis + " ms");
        }
        if (ConfigReader.worldLoadTime) {
            ToastExecutor.executeToast("loading-timer.world_message_text", worldTimeRounded);
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)"Loading Timer");
    }
}

