/*
 * Decompiled with CFR 0.152.
 */
package io.github.blobanium.lt.resource;

import io.github.blobanium.lt.LoadingTimer;
import io.github.blobanium.lt.config.ConfigReader;
import io.github.blobanium.lt.toast.ToastExecutor;
import io.github.blobanium.lt.util.math.MathUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceLoadingTimer {
    private static long resourceStartingTime;
    private static final Logger LOGGER;
    private static double resourceResult;
    public static boolean resourcesLoaded;

    public static void startTimer() {
        resourcesLoaded = false;
        resourceStartingTime = ConfigReader.insanePrecision ? System.nanoTime() : System.currentTimeMillis();
    }

    public static void stopTimer() {
        if (!resourcesLoaded) {
            resourceResult = MathUtil.roundValue(MathUtil.calculateMain(resourceStartingTime));
            LOGGER.info("Resource Loading Time: " + resourceResult + " seconds");
            if (ConfigReader.resourceLoadNotif && (LoadingTimer.timerDone || ConfigReader.resourceLoadNotifStartupOverride)) {
                ToastExecutor.executeToast("loading-timer.resource_loading_text", resourceResult);
            }
            resourcesLoaded = true;
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)"Loading Timer");
        resourcesLoaded = false;
    }
}

