/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.pigpoop.mixin;

import com.focamacho.pigpoop.PigPoop;
import com.focamacho.pigpoop.api.IKnowHowToPoop;
import com.focamacho.pigpoop.api.IPigFood;
import com.focamacho.pigpoop.config.ConfigHolder;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1452;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3417;
import net.minecraft.class_4981;
import net.minecraft.class_5146;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1452.class})
public abstract class PigEntityMixin
extends class_1429
implements IKnowHowToPoop,
class_4981,
class_5146 {
    private int poopTime;
    private class_1792 foodItem;
    private int minPoopTime;
    private int maxPoopTime;

    protected PigEntityMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public void setFoodItem(class_1792 poopItem) {
        this.foodItem = poopItem;
    }

    @Inject(method={"<init>(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo callbackReference) {
        if (this.foodItem == null) {
            this.minPoopTime = ConfigHolder.minPoopTime;
            this.maxPoopTime = ConfigHolder.maxPoopTime;
        } else {
            this.minPoopTime = ((IPigFood)this.foodItem).getPoopMinTime();
            this.maxPoopTime = ((IPigFood)this.foodItem).getPoopMaxTime();
        }
        this.resetPoopTime();
    }

    protected void method_5958() {
        super.method_5958();
        if (!this.field_6002.field_9236 && this.method_5805() && !this.method_6109() && --this.poopTime <= 0) {
            this.method_5783(class_3417.field_21070, 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
            if (this.foodItem == null) {
                this.method_5706((class_1935)PigPoop.poop);
            } else if (this.foodItem == class_1802.field_8071) {
                this.method_5706((class_1935)PigPoop.golden_poop);
                if (!ConfigHolder.infiniteGoldenPoop) {
                    this.foodItem = null;
                }
            } else {
                this.method_5706((class_1935)((IPigFood)this.foodItem).getPoopItem());
                if (!((IPigFood)this.foodItem).isPoopInfinite()) {
                    this.foodItem = null;
                }
            }
            this.resetPoopTime();
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    public void readCustomDataFromTag(class_2487 tag, CallbackInfo callbackInfo) {
        this.foodItem = class_1799.method_7915((class_2487)tag.method_10562("foodItem")).method_7909();
        if (this.foodItem == class_1802.field_8162) {
            this.foodItem = null;
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    public void writeCustomDataToTag(class_2487 tag, CallbackInfo callbackInfo) {
        class_2487 cTag = new class_2487();
        tag.method_10566("foodItem", (class_2520)new class_1799((class_1935)this.foodItem).method_7953(cTag));
    }

    @Inject(method={"interactMob"}, at={@At(value="HEAD")}, cancellable=true)
    public void interactMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> info) {
        if (this.method_6482() && this.getFoodItem() == null) {
            if (player.method_5998(hand).method_7909().equals(class_1802.field_8071)) {
                this.setFoodItem(class_1802.field_8071);
                this.minPoopTime = ConfigHolder.minPoopTime;
                this.maxPoopTime = ConfigHolder.maxPoopTime;
                player.method_5998(hand).method_7934(1);
                this.method_6480(player);
                this.resetPoopTime();
                info.setReturnValue((Object)class_1269.field_21466);
            } else if (player.method_5998(hand).method_7909() instanceof IPigFood) {
                IPigFood food = (IPigFood)player.method_5998(hand).method_7909();
                this.setFoodItem(player.method_5998(hand).method_7909());
                this.minPoopTime = food.getPoopMinTime();
                this.maxPoopTime = food.getPoopMaxTime();
                player.method_5998(hand).method_7934(1);
                this.method_6480(player);
                this.resetPoopTime();
                info.setReturnValue((Object)class_1269.field_21466);
            }
        }
    }

    private void resetPoopTime() {
        this.poopTime = this.field_5974.nextInt(this.maxPoopTime - this.minPoopTime) + this.minPoopTime;
    }

    @Override
    public class_1792 getFoodItem() {
        return this.foodItem;
    }

    @Override
    public int getPoopTime() {
        return this.poopTime;
    }
}

