/*
 * Decompiled with CFR 0.152.
 */
package moe.caa.forge.quitconfirm.client.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import moe.caa.forge.quitconfirm.client.main.QuitConfirm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;

@OnlyIn(value=Dist.CLIENT)
public class Config {
    public static final AtomicReference<Config> config = new AtomicReference<Config>(new Config());
    private static final File CONFIG_FOLDER = new File("config");
    private static final File CONFIG_FILE = new File(CONFIG_FOLDER, "quitconfirm.json");
    public boolean inFinal = true;
    public boolean inIntegrated = false;
    public boolean inDedicated = true;
    public boolean inReams = true;
    public boolean shortcutKet = false;
    public boolean transparentBackground = true;
    public boolean nonInductiveExit = false;
    public long keepInAction = 1000L;
    public int confirmScreenStyle = 0;

    private static synchronized void readNew() {
        if (!CONFIG_FILE.exists()) {
            return;
        }
        Config value = null;
        try {
            value = (Config)QuitConfirm.GSON.fromJson((Reader)new FileReader(CONFIG_FILE), Config.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value != null) {
            config.set(value);
        }
    }

    public static synchronized void save() throws IOException {
        if (!CONFIG_FOLDER.exists() && !CONFIG_FOLDER.mkdirs()) {
            throw new IOException("Unable to create data folder: " + CONFIG_FOLDER.getAbsolutePath());
        }
        if (!CONFIG_FILE.exists() && !CONFIG_FILE.createNewFile()) {
            throw new IOException("Unable to create data file: " + CONFIG_FILE.getAbsolutePath());
        }
        try (FileWriter fw = new FileWriter(CONFIG_FILE);){
            fw.write(QuitConfirm.GSON.toJson((Object)config.get()));
        }
    }

    public static void saveConfig() {
        try {
            Config.save();
        }
        catch (Throwable e) {
            QuitConfirm.LOGGER.log(Level.ERROR, "Unable to save configuration.", e);
        }
    }

    static {
        Config.readNew();
        QuitConfirm.TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                Config.saveConfig();
            }
        }, 0L, 3600000L);
    }
}

