/*
 * Decompiled with CFR 0.152.
 */
package com.dyonovan.repairchests.blocks;

import com.dyonovan.repairchests.RepairChests;
import com.dyonovan.repairchests.blocks.AdvancedChestBlock;
import com.dyonovan.repairchests.blocks.BasicChestBlock;
import com.dyonovan.repairchests.blocks.RepairChestTypes;
import com.dyonovan.repairchests.blocks.UltimateChestBlock;
import com.dyonovan.repairchests.items.RepairChestItems;
import com.dyonovan.repairchests.items.RepairChestsBlockItem;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RepairChestBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"repairchests");
    public static final DeferredRegister<Item> ITEMS = RepairChestItems.ITEMS;
    public static final RegistryObject<BasicChestBlock> BASIC_CHEST = RepairChestBlocks.register("basic_chest", () -> new BasicChestBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f)), RepairChestTypes.BASIC);
    public static final RegistryObject<AdvancedChestBlock> ADVANCED_CHEST = RepairChestBlocks.register("advanced_chest", () -> new AdvancedChestBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f)), RepairChestTypes.ADVANCED);
    public static final RegistryObject<UltimateChestBlock> ULTIMATE_CHEST = RepairChestBlocks.register("ultimate_chest", () -> new UltimateChestBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f)), RepairChestTypes.ULTIMATE);

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, RepairChestTypes chestType) {
        return RepairChestBlocks.register(name, sup, (RegistryObject<T> block) -> RepairChestBlocks.item((RegistryObject<? extends Block>)block, () -> () -> chestType));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<? extends T> sup, Function<RegistryObject<T>, Supplier<? extends Item>> itemCreator) {
        RegistryObject<? extends T> ret = RepairChestBlocks.registerNoItem(name, sup);
        ITEMS.register(name, itemCreator.apply(ret));
        return ret;
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<? extends T> sup) {
        return BLOCKS.register(name, sup);
    }

    private static Supplier<BlockItem> item(RegistryObject<? extends Block> block, Supplier<Callable<RepairChestTypes>> chestType) {
        return () -> new RepairChestsBlockItem((Block)block.get(), new Item.Properties().m_41491_(RepairChests.REPAIR_CHESTS_ITEM_GROUP), chestType);
    }
}

