/*
 * Decompiled with CFR 0.152.
 */
package com.dyonovan.repairchests.blocks;

import com.dyonovan.repairchests.Util;
import com.dyonovan.repairchests.blocks.AdvancedChestBlock;
import com.dyonovan.repairchests.blocks.BasicChestBlock;
import com.dyonovan.repairchests.blocks.RepairChestBlocks;
import com.dyonovan.repairchests.blocks.UltimateChestBlock;
import com.dyonovan.repairchests.blocks.entity.AbstractRepairChestBlockEntity;
import com.dyonovan.repairchests.blocks.entity.AdvancedChestBlockEntity;
import com.dyonovan.repairchests.blocks.entity.BasicChestBlockEntity;
import com.dyonovan.repairchests.blocks.entity.UltimateChestBlockEntity;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public enum RepairChestTypes implements StringRepresentable
{
    BASIC(1, 1, 184, 184, new ResourceLocation("repairchests", "textures/gui/basic_container.png"), 256, 256),
    ADVANCED(9, 9, 184, 133, new ResourceLocation("repairchests", "textures/gui/advanced_container.png"), 256, 256),
    ULTIMATE(18, 9, 184, 150, new ResourceLocation("repairchests", "textures/gui/ultimate_container.png"), 256, 256);

    private final String name;
    public final int size;
    public final int rowLength;
    public final int xSize;
    public final int ySize;
    public final ResourceLocation guiTexture;
    public final int textureXSize;
    public final int textureYSize;

    private RepairChestTypes(int size, int rowLength, int xSize, int ySize, ResourceLocation guiTexture, int textureXSize, int textureYSize) {
        this(null, size, rowLength, xSize, ySize, guiTexture, textureXSize, textureYSize);
    }

    private RepairChestTypes(String name, int size, int rowLength, int xSize, int ySize, ResourceLocation guiTexture, int textureXSize, int textureYSize) {
        this.name = name == null ? Util.toEnglishName(this.name()) : name;
        this.size = size;
        this.rowLength = rowLength;
        this.xSize = xSize;
        this.ySize = ySize;
        this.guiTexture = guiTexture;
        this.textureXSize = textureXSize;
        this.textureYSize = textureYSize;
    }

    public String getId() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getEnglishName() {
        return this.name;
    }

    public int getRowCount() {
        return this.size / this.rowLength;
    }

    public boolean isTransparent() {
        return false;
    }

    public static Block get(RepairChestTypes type) {
        return switch (type) {
            case BASIC -> (BasicChestBlock)RepairChestBlocks.BASIC_CHEST.get();
            case ADVANCED -> (AdvancedChestBlock)RepairChestBlocks.ADVANCED_CHEST.get();
            case ULTIMATE -> (UltimateChestBlock)RepairChestBlocks.ULTIMATE_CHEST.get();
            default -> Blocks.f_50087_;
        };
    }

    @Nullable
    public AbstractRepairChestBlockEntity makeEntity(BlockPos blockPos, BlockState blockState) {
        return switch (this) {
            case BASIC -> new BasicChestBlockEntity(blockPos, blockState);
            case ADVANCED -> new AdvancedChestBlockEntity(blockPos, blockState);
            case ULTIMATE -> new UltimateChestBlockEntity(blockPos, blockState);
            default -> null;
        };
    }

    public String m_7912_() {
        return this.getEnglishName();
    }
}

