/*
 * Decompiled with CFR 0.152.
 */
package com.dyonovan.repairchests.client.render;

import com.dyonovan.repairchests.RepairChestsClientEvents;
import com.dyonovan.repairchests.blocks.GenericRepairChestBlock;
import com.dyonovan.repairchests.blocks.RepairChestTypes;
import com.dyonovan.repairchests.blocks.entity.AbstractRepairChestBlockEntity;
import com.dyonovan.repairchests.client.model.RepairChestModels;
import com.dyonovan.repairchests.client.model.inventory.ModelItem;
import com.google.common.primitives.SignedBytes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RepairChestRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private static ItemEntity customItem;
    private static ItemEntityRenderer itemRenderer;
    private final BlockEntityRenderDispatcher renderer;
    private static final List<ModelItem> MODEL_ITEMS;

    public RepairChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelPart = context.m_173582_(RepairChestsClientEvents.BASIC_CHEST);
        this.renderer = context.m_173581_();
        this.bottom = modelPart.m_171324_("basic_bottom");
        this.lid = modelPart.m_171324_("basic_lid");
        this.lock = modelPart.m_171324_("basic_lock");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("basic_bottom", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.f_171404_);
        partDefinition.m_171599_("basic_lid", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.m_171599_("basic_lock", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        Block block;
        AbstractRepairChestBlockEntity tileEntity = (AbstractRepairChestBlockEntity)((Object)tileEntityIn);
        Level level = tileEntity.m_58904_();
        boolean useTileEntityBlockState = level != null;
        BlockState blockState = useTileEntityBlockState ? tileEntity.m_58900_() : (BlockState)tileEntity.getBlockToUse().m_49966_().m_61124_((Property)GenericRepairChestBlock.FACING, (Comparable)Direction.SOUTH);
        Block block2 = blockState.m_60734_();
        RepairChestTypes chestType = RepairChestTypes.BASIC;
        RepairChestTypes actualType = GenericRepairChestBlock.getTypeFromBlock(block2);
        if (actualType != null) {
            chestType = actualType;
        }
        if ((block = block2) instanceof GenericRepairChestBlock) {
            GenericRepairChestBlock abstractChestBlock = (GenericRepairChestBlock)block;
            poseStack.m_85836_();
            float f = ((Direction)blockState.m_61143_((Property)GenericRepairChestBlock.FACING)).m_122435_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult<? extends AbstractRepairChestBlockEntity> neighborCombineResult = useTileEntityBlockState ? abstractChestBlock.combine(blockState, level, tileEntityIn.m_58899_(), true) : DoubleBlockCombiner.Combiner::m_6502_;
            float openness = ((Float2FloatFunction)neighborCombineResult.m_5649_(GenericRepairChestBlock.opennessCombiner(tileEntity))).get(partialTicks);
            openness = 1.0f - openness;
            openness = 1.0f - openness * openness * openness;
            int brightness = ((Int2IntFunction)neighborCombineResult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            Material material = new Material(Sheets.f_110740_, RepairChestModels.chooseChestTexture(chestType));
            VertexConsumer vertexConsumer = material.m_119194_(bufferSource, RenderType::m_110452_);
            this.render(poseStack, vertexConsumer, this.lid, this.lock, this.bottom, openness, brightness, combinedOverlayIn);
            poseStack.m_85849_();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer vertexConsumer, ModelPart lid, ModelPart lock, ModelPart bottom, float openness, int brightness, int combinedOverlayIn) {
        lock.f_104203_ = lid.f_104203_ = -(openness * 1.5707964f);
        lid.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        lock.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
        bottom.m_104301_(poseStack, vertexConsumer, brightness, combinedOverlayIn);
    }

    public static void renderItem(PoseStack matrices, MultiBufferSource buffer, ItemStack item, ModelItem modelItem, float rotation, int light, float partialTicks) {
        if (item.m_41619_()) {
            return;
        }
        customItem.m_32045_(item);
        matrices.m_85836_();
        Vector3f center = modelItem.getCenter();
        matrices.m_85837_((double)center.m_122239_(), (double)center.m_122260_(), (double)center.m_122269_());
        matrices.m_85845_(Vector3f.f_122225_.m_122270_(rotation));
        float scale = modelItem.getSizeScaled();
        matrices.m_85841_(scale, scale, scale);
        if (itemRenderer == null) {
            itemRenderer = new ItemEntityRenderer(new EntityRendererProvider.Context(Minecraft.m_91087_().m_91290_(), Minecraft.m_91087_().m_91291_(), Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().f_91062_)){

                public int m_115042_(ItemStack stack) {
                    return SignedBytes.saturatedCast((long)(Math.min(stack.m_41613_() / 32, 15) + 1));
                }

                public boolean shouldBob() {
                    return false;
                }

                public boolean shouldSpreadItems() {
                    return true;
                }
            };
        }
        itemRenderer.m_7392_(customItem, 0.0f, partialTicks, matrices, buffer, light);
        matrices.m_85849_();
    }

    static {
        MODEL_ITEMS = Arrays.asList(new ModelItem(new Vector3f(0.3f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.45f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.3f), 3.0f), new ModelItem(new Vector3f(0.3f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.7f, 0.1f, 0.7f), 3.0f), new ModelItem(new Vector3f(0.5f, 0.32f, 0.5f), 3.0f));
    }
}

