/*
 * Decompiled with CFR 0.152.
 */
package com.dyonovan.repairchests.inventory;

import com.dyonovan.repairchests.blocks.RepairChestTypes;
import com.dyonovan.repairchests.inventory.RepairChestsContainerTypes;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RepairChestMenu
extends AbstractContainerMenu {
    private final Container container;
    private final RepairChestTypes chestType;

    private RepairChestMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(RepairChestTypes.BASIC.size), RepairChestTypes.BASIC);
    }

    public static RepairChestMenu createBasicContainer(int containerId, Inventory playerInventory) {
        return new RepairChestMenu((MenuType)RepairChestsContainerTypes.BASIC_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(RepairChestTypes.BASIC.size), RepairChestTypes.BASIC);
    }

    public static RepairChestMenu createBasicContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new RepairChestMenu((MenuType)RepairChestsContainerTypes.BASIC_CHEST.get(), containerId, playerInventory, inventory, RepairChestTypes.BASIC);
    }

    public static RepairChestMenu createAdvancedContainer(int containerId, Inventory playerInventory) {
        return new RepairChestMenu((MenuType)RepairChestsContainerTypes.ADVANCED_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(RepairChestTypes.ADVANCED.size), RepairChestTypes.ADVANCED);
    }

    public static RepairChestMenu createAdvancedContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new RepairChestMenu((MenuType)RepairChestsContainerTypes.ADVANCED_CHEST.get(), containerId, playerInventory, inventory, RepairChestTypes.ADVANCED);
    }

    public static RepairChestMenu createUltimateContainer(int containerId, Inventory playerInventory) {
        return new RepairChestMenu((MenuType)RepairChestsContainerTypes.ULTIMATE_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(RepairChestTypes.ULTIMATE.size), RepairChestTypes.ULTIMATE);
    }

    public static RepairChestMenu createUltimateContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new RepairChestMenu((MenuType)RepairChestsContainerTypes.ULTIMATE_CHEST.get(), containerId, playerInventory, inventory, RepairChestTypes.ULTIMATE);
    }

    protected RepairChestMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, Container inventory, RepairChestTypes chestType) {
        super(menuType, containerId);
        RepairChestMenu.m_38869_((Container)inventory, (int)chestType.size);
        this.container = inventory;
        this.chestType = chestType;
        inventory.m_5856_(playerInventory.f_35978_);
        if (chestType == RepairChestTypes.BASIC) {
            this.m_38897_(new Slot(inventory, 0, 84, 44));
        } else {
            for (int chestRow = 0; chestRow < chestType.getRowCount(); ++chestRow) {
                for (int chestCol = 0; chestCol < chestType.rowLength; ++chestCol) {
                    this.m_38897_(new Slot(inventory, chestCol + chestRow * chestType.rowLength, 12 + chestCol * 18, 18 + chestRow * 18));
                }
            }
        }
        int leftCol = (chestType.xSize - 162) / 2 + 1;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.m_38897_(new Slot((Container)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, chestType.ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, chestType.ySize - 24));
        }
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.chestType.size ? !this.m_38903_(itemstack1, this.chestType.size, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.chestType.size, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.container.m_5785_(playerIn);
    }

    public Container getContainer() {
        return this.container;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RepairChestTypes getChestType() {
        return this.chestType;
    }
}

