/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.capabilities;

import com.dainxt.weaponthrow.interfaces.IThrowPower;
import net.minecraft.core.Direction;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ThrowProvider
implements IThrowPower,
ICapabilitySerializable<Tag> {
    @CapabilityInject(value=IThrowPower.class)
    public static final Capability<IThrowPower> THROW_POWER = null;
    private LazyOptional<IThrowPower> instance = LazyOptional.of(() -> this);
    int prevChargeTime = -1;
    int chargeTime = -1;

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return THROW_POWER.orEmpty(capability, this.instance);
    }

    public Tag serializeNBT() {
        IThrowPower capability = (IThrowPower)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"));
        return IntTag.m_128679_((int)capability.getChargeTime());
    }

    public void deserializeNBT(Tag nbt) {
        IThrowPower capability = (IThrowPower)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"));
        capability.setChargeTime(((NumericTag)nbt).m_7047_());
    }

    @Override
    public int getChargeTime() {
        return this.chargeTime;
    }

    @Override
    public void setChargeTime(int ticks) {
        this.chargeTime = ticks;
    }

    @Override
    public boolean doesMaxChargeChanged() {
        return this.prevChargeTime != this.chargeTime;
    }

    @Override
    public void tick() {
        this.prevChargeTime = this.chargeTime;
    }
}

