/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.packets;

import com.dainxt.weaponthrow.handlers.EventsHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class SPacketThrow {
    private final int progress;
    private UUID playerAnimated;

    public SPacketThrow(UUID player, int maxTime) {
        this.progress = maxTime;
        this.playerAnimated = player;
    }

    public static void encode(SPacketThrow msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.playerAnimated.toString());
        buf.writeInt(msg.progress);
    }

    public static SPacketThrow decode(FriendlyByteBuf buf) {
        return new SPacketThrow(UUID.fromString(buf.m_130277_()), buf.readInt());
    }

    public static void handle(SPacketThrow msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> EventsHandler.onSeverUpdate(msg.playerAnimated, msg.progress));
        }
        ctx.get().setPacketHandled(true);
    }
}

