/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class TextureSet
implements Comparable<TextureSet> {
    public final class_2960 name;
    public final ITexture[] textures;
    private final Set<class_2960> stitchTo = new HashSet<class_2960>();
    private final Set<class_2960> stitchToHorizontal = new HashSet<class_2960>();
    private final Set<class_2960> stitchToVertical = new HashSet<class_2960>();
    private final class_2960[] texturePaths;
    private boolean stitchesToNull = false;
    private boolean anisotropicStitching = false;

    public TextureSet(class_2960 name, class_2960 ... textures) {
        this.name = name;
        this.texturePaths = textures;
        this.textures = new ITexture[textures.length];
    }

    public TextureSet stitchesToNull() {
        this.stitchesToNull = true;
        return this;
    }

    public TextureSet stitchTo(class_2960 ... textureSets) {
        Collections.addAll(this.stitchTo, textureSets);
        Collections.addAll(this.stitchToHorizontal, textureSets);
        Collections.addAll(this.stitchToVertical, textureSets);
        return this;
    }

    public TextureSet stitchToHorizontal(class_2960 ... textureSets) {
        this.anisotropicStitching = true;
        Collections.addAll(this.stitchToHorizontal, textureSets);
        return this;
    }

    public TextureSet stitchToVertical(class_2960 ... textureSets) {
        this.anisotropicStitching = true;
        Collections.addAll(this.stitchToVertical, textureSets);
        return this;
    }

    public boolean shouldStitchTo(TextureSet toSet) {
        return toSet == this || this.stitchesToNull && toSet == null || this.stitchTo.contains(toSet.name);
    }

    public boolean shouldStitchToHorizontally(TextureSet toSet) {
        if (toSet == this || this.stitchesToNull && toSet == null) {
            return true;
        }
        if (this.anisotropicStitching) {
            return this.stitchToHorizontal.contains(toSet.name);
        }
        return this.stitchTo.contains(toSet.name);
    }

    public boolean shouldStitchToVertically(TextureSet toSet) {
        if (toSet == this || this.stitchesToNull && toSet == null) {
            return true;
        }
        if (this.anisotropicStitching) {
            return this.stitchToVertical.contains(toSet.name);
        }
        return this.stitchTo.contains(toSet.name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextureSet)) {
            return false;
        }
        TextureSet set = (TextureSet)obj;
        return this.name.equals((Object)set.name);
    }

    @Override
    public int compareTo(TextureSet textureSet) {
        return this.name.toString().compareTo(textureSet.name.toString());
    }

    public ITexture getTexture(int variationNumber) {
        return this.textures[variationNumber % this.textures.length];
    }

    public class_2960[] getTexturePaths() {
        return this.texturePaths;
    }

    public void loadTextures() {
        for (int i = 0; i < this.texturePaths.length; ++i) {
            if (!Textures.TILE_TEXTURES_MAP.containsKey(this.texturePaths[i])) {
                throw new RuntimeException("Couldn't find the specified texture: " + this.texturePaths[i].toString());
            }
            this.textures[i] = Textures.TILE_TEXTURES_MAP.get(this.texturePaths[i]);
        }
    }

    public void checkStitching() {
        this.stitchTo.stream().filter(identifier -> !TextureSetMap.isRegistered(identifier)).forEach(identifier -> Log.error("The texture set %s tries to stitch to %s, which does not exists.", this.name, identifier));
        this.stitchToVertical.stream().filter(identifier -> !TextureSetMap.isRegistered(identifier)).forEach(identifier -> Log.error("The texture set %s tries to stitch vertically to %s, which does not exists.", this.name, identifier));
        this.stitchToHorizontal.stream().filter(identifier -> !TextureSetMap.isRegistered(identifier)).forEach(identifier -> Log.error("The texture set %s tries to stitch horizontally to %s, which does not exists.", this.name, identifier));
    }

    public static class TextureSetShore
    extends TextureSet {
        public final class_2960 waterName;
        private TextureSet water;

        TextureSetShore(class_2960 name, class_2960 water, class_2960 ... textures) {
            super(name, textures);
            this.waterName = water;
        }

        public void loadWater() {
            this.water = TextureSetMap.instance().getByName(this.waterName);
        }

        @Override
        public boolean shouldStitchToHorizontally(TextureSet otherSet) {
            return otherSet == this || !this.water.shouldStitchToHorizontally(otherSet);
        }

        @Override
        public boolean shouldStitchToVertically(TextureSet otherSet) {
            return otherSet == this || !this.water.shouldStitchToVertically(otherSet);
        }
    }
}

