/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Environment(value=EnvType.CLIENT)
public class TileTextureConfig
implements SimpleResourceReloadListener<Map<class_2960, class_2960>> {
    private static final int VERSION = 1;
    private static final JsonParser PARSER = new JsonParser();
    private final TileTextureMap tileTextureMap;
    private final TextureSetMap textureSetMap;

    public TileTextureConfig(TileTextureMap biomeTextureMap, TextureSetMap textureSetMap) {
        this.tileTextureMap = biomeTextureMap;
        this.textureSetMap = textureSetMap;
    }

    public CompletableFuture<Map<class_2960, class_2960>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<class_2960, class_2960> map = new HashMap<class_2960, class_2960>();
            try {
                for (class_2960 id : manager.method_14488("atlas/tiles", s -> s.endsWith(".json"))) {
                    class_2960 tile_id = new class_2960(id.method_12836(), id.method_12832().replace("atlas/tiles/", "").replace(".json", ""));
                    try {
                        class_3298 resource = manager.method_14486(id);
                        InputStream stream = resource.method_14482();
                        try (InputStreamReader reader = new InputStreamReader(stream);){
                            JsonObject object = PARSER.parse((Reader)reader).getAsJsonObject();
                            int version = object.getAsJsonPrimitive("version").getAsInt();
                            if (version != 1) {
                                AntiqueAtlasMod.LOG.warn("The tile " + tile_id + " is in the wrong version! Skipping.");
                                continue;
                            }
                            class_2960 texture_set = new class_2960(object.get("texture_set").getAsString());
                            map.put(tile_id, texture_set);
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading tile mapping " + tile_id + "!", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read tile mappings!", new Object[0]);
            }
            return map;
        });
    }

    public CompletableFuture<Void> apply(Map<class_2960, class_2960> tileMap, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : tileMap.entrySet()) {
                class_2960 tile_id = (class_2960)entry.getKey();
                class_2960 texture_set = (class_2960)entry.getValue();
                TextureSet set = this.textureSetMap.getByName((class_2960)entry.getValue());
                if (set == null) {
                    AntiqueAtlasMod.LOG.error("Missing texture set `{}` for tile `{}`. Using default.", (Object)texture_set, (Object)tile_id);
                    set = this.tileTextureMap.getDefaultTexture();
                }
                this.tileTextureMap.setTexture((class_2960)entry.getKey(), set);
                Log.info("Using texture set %s for tile %s", set.name, tile_id);
            }
        });
    }

    public class_2960 getFabricId() {
        return new class_2960("antiqueatlas:tile_textures");
    }

    public Collection<class_2960> getFabricDependencies() {
        return Collections.singleton(new class_2960("antiqueatlas:texture_sets"));
    }
}

