/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorEnd;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorNether;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class WorldScanner {
    private final Map<class_5321<class_1937>, ITileDetector> biomeAnalyzers = new HashMap<class_5321<class_1937>, ITileDetector>();
    private final TileDetectorBase tileDetectorOverworld = new TileDetectorBase();

    public WorldScanner() {
        this.setBiomeDetectorForWorld((class_5321<class_1937>)class_1937.field_25179, this.tileDetectorOverworld);
        this.setBiomeDetectorForWorld((class_5321<class_1937>)class_1937.field_25180, new TileDetectorNether());
        this.setBiomeDetectorForWorld((class_5321<class_1937>)class_1937.field_25181, new TileDetectorEnd());
    }

    private ITileDetector getBiomeDetectorForWorld(class_5321<class_1937> world) {
        ITileDetector biomeAnalyzer = this.biomeAnalyzers.get(world);
        return biomeAnalyzer == null ? this.tileDetectorOverworld : biomeAnalyzer;
    }

    private void setBiomeDetectorForWorld(class_5321<class_1937> world, ITileDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(world, biomeAnalyzer);
    }

    public Collection<TileInfo> updateAtlasAroundPlayer(AtlasData data, class_1657 player) {
        int newScanInterval = Math.round(AntiqueAtlasMod.CONFIG.newScanInterval * 20.0f);
        if (player.method_5770().method_8510() % (long)newScanInterval != 0L) {
            return Collections.emptyList();
        }
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int rescanInterval = newScanInterval * AntiqueAtlasMod.CONFIG.rescanRate;
        boolean rescanRequired = AntiqueAtlasMod.CONFIG.doRescan && player.method_5770().method_8510() % (long)rescanInterval == 0L;
        ITileDetector biomeDetector = this.getBiomeDetectorForWorld((class_5321<class_1937>)player.method_5770().method_27983());
        int scanRadius = biomeDetector.getScanRadius();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                if (dx * dx + dz * dz > scanRadius * scanRadius) continue;
                int chunkX = player.method_31476().field_9181 + dx;
                int chunkZ = player.method_31476().field_9180 + dz;
                TileInfo update = this.updateAtlasForChunk(data, player.method_5770(), chunkX, chunkZ, rescanRequired);
                if (update == null) continue;
                updatedTiles.add(update);
            }
        }
        return updatedTiles;
    }

    private TileInfo updateAtlasForChunk(AtlasData data, class_1937 world, int x, int z, boolean rescanRequired) {
        WorldData storedData = data.getWorldData((class_5321<class_1937>)world.method_27983());
        class_2960 oldTile = storedData.getTile(x, z);
        class_2960 tile = AtlasAPI.getTileAPI().getGlobalTile(world, x, z);
        if (tile == null) {
            if (oldTile != null && !rescanRequired) {
                return null;
            }
            class_2791 chunk = world.method_8402(x, z, class_2806.field_12803, AntiqueAtlasMod.CONFIG.forceChunkLoading);
            if (chunk == null) {
                return null;
            }
            ITileDetector biomeDetector = this.getBiomeDetectorForWorld((class_5321<class_1937>)world.method_27983());
            tile = biomeDetector.getBiomeID(world, chunk);
            if (oldTile != null) {
                if (tile == null) {
                    data.removeTile((class_5321<class_1937>)world.method_27983(), x, z);
                } else if (!oldTile.equals((Object)tile)) {
                    data.setTile((class_5321<class_1937>)world.method_27983(), x, z, tile);
                    return new TileInfo(x, z, tile);
                }
            } else if (tile != null) {
                data.setTile((class_5321<class_1937>)world.method_27983(), x, z, tile);
                return new TileInfo(x, z, tile);
            }
        } else if (oldTile == null || !oldTile.equals((Object)tile)) {
            data.setTile((class_5321<class_1937>)world.method_27983(), x, z, tile);
            data.method_80();
            return new TileInfo(x, z, tile);
        }
        return null;
    }
}

