/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.compat.autoswitch_api.impl;

import autoswitch.AutoSwitch;
import autoswitch.api.AutoSwitchApi;
import autoswitch.api.AutoSwitchMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.SerializationUtils;

public class ApiGenUtil {
    public static final Object2ObjectOpenHashMap<String, Set<String>> modActionConfigs = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<String, Set<String>> modUseConfigs = new Object2ObjectOpenHashMap();

    public static void pullHookedMods() {
        FabricLoader.getInstance().getEntrypointContainers("autoswitch", AutoSwitchApi.class).forEach(entrypoint -> {
            AutoSwitchApi api = (AutoSwitchApi)entrypoint.getEntrypoint();
            api.customDamageSystems(AutoSwitch.switchData.damageMap);
            api.moddedToolGroups(AutoSwitch.switchData.toolGroupings);
            AutoSwitchMap<String, String> baseAction = ApiGenUtil.duplicateMap(AutoSwitch.switchData.attackConfig);
            AutoSwitchMap<String, String> baseUseAction = ApiGenUtil.duplicateMap(AutoSwitch.switchData.usableConfig);
            api.moddedTargets(AutoSwitch.switchData.targets, AutoSwitch.switchData.attackConfig, AutoSwitch.switchData.usableConfig);
            String name = entrypoint.getProvider().getMetadata().getName();
            ApiGenUtil.processActionDif(name, baseAction);
            ApiGenUtil.processUseDif(name, baseUseAction);
            AutoSwitch.logger.info("AutoSwitch has interfaced with the {} mod!", (Object)name);
        });
    }

    private static <K, V> AutoSwitchMap<K, V> duplicateMap(AutoSwitchMap<K, V> map) {
        return (AutoSwitchMap)SerializationUtils.clone(map);
    }

    private static void processActionDif(String mod, AutoSwitchMap<String, String> base) {
        ApiGenUtil.processMapDiff(mod, base, AutoSwitch.switchData.attackConfig, modActionConfigs);
    }

    private static void processUseDif(String mod, AutoSwitchMap<String, String> base) {
        ApiGenUtil.processMapDiff(mod, base, AutoSwitch.switchData.usableConfig, modUseConfigs);
    }

    private static void processMapDiff(String mod, AutoSwitchMap<String, String> base, AutoSwitchMap<String, String> config, Object2ObjectOpenHashMap<String, Set<String>> populationTarget) {
        Set<String> diff = ApiGenUtil.diffMaps(base, config);
        if (diff != null) {
            populationTarget.put((Object)mod, diff);
        }
    }

    private static Set<String> diffMaps(AutoSwitchMap<String, String> base, AutoSwitchMap<String, String> modded) {
        if (!base.equals(modded)) {
            MapDifference diff = Maps.difference(base, modded);
            return diff.entriesOnlyOnRight().keySet();
        }
        return null;
    }
}

