/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.compat.autoswitch_api.impl;

import autoswitch.AutoSwitch;
import autoswitch.config.AutoSwitchAttackActionConfig;
import autoswitch.config.AutoSwitchUseActionConfig;
import autoswitch.config.util.ConfigReflection;
import autoswitch.util.SwitchData;
import autoswitch.util.SwitchUtil;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_1299;
import net.minecraft.class_1310;
import net.minecraft.class_1743;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_3614;
import org.apache.commons.lang3.tuple.Pair;

public class ApiMapGenerator {
    public static void createApiMaps() {
        AutoSwitch.switchData.toolGroupings.put((Object)"pickaxe", (Object)Pair.of((Object)FabricToolTags.PICKAXES, class_1810.class));
        AutoSwitch.switchData.toolGroupings.put((Object)"shovel", (Object)Pair.of((Object)FabricToolTags.SHOVELS, class_1821.class));
        AutoSwitch.switchData.toolGroupings.put((Object)"hoe", (Object)Pair.of((Object)FabricToolTags.HOES, class_1794.class));
        AutoSwitch.switchData.toolGroupings.put((Object)"shears", (Object)Pair.of((Object)FabricToolTags.SHEARS, class_1820.class));
        AutoSwitch.switchData.toolGroupings.put((Object)"trident", (Object)Pair.of(null, class_1835.class));
        AutoSwitch.switchData.toolGroupings.put((Object)"axe", (Object)Pair.of((Object)FabricToolTags.AXES, class_1743.class));
        AutoSwitch.switchData.toolGroupings.put((Object)"sword", (Object)Pair.of((Object)FabricToolTags.SWORDS, class_1829.class));
        ApiMapGenerator.genTargetMap();
        ApiMapGenerator.genConfigMaps();
    }

    private static void genTargetMap() {
        ApiMapGenerator.addTarget("solid_organic", class_3614.field_15945);
        ApiMapGenerator.addTarget("repair_station", class_3614.field_15949);
        ApiMapGenerator.addTarget("bamboo", class_3614.field_15946);
        ApiMapGenerator.addTarget("bamboo_sapling", class_3614.field_15938);
        ApiMapGenerator.addTarget("cactus", class_3614.field_15925);
        ApiMapGenerator.addTarget("cake", class_3614.field_15937);
        ApiMapGenerator.addTarget("carpet", class_3614.field_15957);
        ApiMapGenerator.addTarget("organic_product", class_3614.field_15936);
        ApiMapGenerator.addTarget("cobweb", class_3614.field_15913);
        ApiMapGenerator.addTarget("soil", class_3614.field_15941);
        ApiMapGenerator.addTarget("egg", class_3614.field_15930);
        ApiMapGenerator.addTarget("glass", class_3614.field_15942);
        ApiMapGenerator.addTarget("ice", class_3614.field_15958);
        ApiMapGenerator.addTarget("leaves", class_3614.field_15923);
        ApiMapGenerator.addTarget("metal", class_3614.field_15953);
        ApiMapGenerator.addTarget("dense_ice", class_3614.field_15928);
        ApiMapGenerator.addTarget("sub_block", class_3614.field_15924);
        ApiMapGenerator.addTarget("piston", class_3614.field_15933);
        ApiMapGenerator.addTarget("plant", class_3614.field_15935);
        ApiMapGenerator.addTarget("gourd", class_3614.field_15954);
        ApiMapGenerator.addTarget("redstone_lamp", class_3614.field_15918);
        ApiMapGenerator.addTarget("replaceable_plant", class_3614.field_15956);
        ApiMapGenerator.addTarget("aggregate", class_3614.field_15916);
        ApiMapGenerator.addTarget("replaceable_underwater_plant", class_3614.field_15926);
        ApiMapGenerator.addTarget("shulker_box", class_3614.field_17008);
        ApiMapGenerator.addTarget("snow_layer", class_3614.field_15948);
        ApiMapGenerator.addTarget("snow_block", class_3614.field_15934);
        ApiMapGenerator.addTarget("sponge", class_3614.field_15917);
        ApiMapGenerator.addTarget("nether_wood", class_3614.field_22223);
        ApiMapGenerator.addTarget("stone", class_3614.field_15914);
        ApiMapGenerator.addTarget("tnt", class_3614.field_15955);
        ApiMapGenerator.addTarget("nether_shoots", class_3614.field_26708);
        ApiMapGenerator.addTarget("underwater_plant", class_3614.field_15947);
        ApiMapGenerator.addTarget("moss_block", class_3614.field_15921);
        ApiMapGenerator.addTarget("wood", class_3614.field_15932);
        ApiMapGenerator.addTarget("wool", class_3614.field_15931);
        ApiMapGenerator.addTarget("water", class_3614.field_15920);
        ApiMapGenerator.addTarget("fire", class_3614.field_15943);
        ApiMapGenerator.addTarget("lava", class_3614.field_15922);
        ApiMapGenerator.addTarget("barrier", class_3614.field_15952);
        ApiMapGenerator.addTarget("bubble_column", class_3614.field_15915);
        ApiMapGenerator.addTarget("air", class_3614.field_15959);
        ApiMapGenerator.addTarget("portal", class_3614.field_15919);
        ApiMapGenerator.addTarget("structure_void", class_3614.field_15927);
        if (ApiMapGenerator.isAcceptableVersion("1.17-alpha.20.49.a")) {
            ApiMapGenerator.addTarget("amethyst", class_3614.field_27340);
            ApiMapGenerator.addTarget("passable_snow_block", class_3614.field_27890);
            ApiMapGenerator.addTarget("sculk", class_3614.field_28242);
        }
        ApiMapGenerator.addTarget("aquaticEntity", class_1310.field_6292);
        ApiMapGenerator.addTarget("arthropod", class_1310.field_6293);
        ApiMapGenerator.addTarget("defaultEntity", class_1310.field_6290);
        ApiMapGenerator.addTarget("illager", class_1310.field_6291);
        ApiMapGenerator.addTarget("undead", class_1310.field_6289);
        ApiMapGenerator.addTarget("ender_dragon", class_1299.field_6116);
        ApiMapGenerator.addTarget("bow_action", SwitchData.itemTarget);
    }

    private static void genConfigMaps() {
        ConfigReflection.defaults(AutoSwitch.switchData.attackConfig, AutoSwitchAttackActionConfig.class);
        ConfigReflection.defaults(AutoSwitch.switchData.usableConfig, AutoSwitchUseActionConfig.class);
    }

    private static void addTarget(String name, Object target) {
        AutoSwitch.switchData.targets.put((Object)name, target);
    }

    private static boolean isAcceptableVersion(String minVersion) {
        try {
            return SemanticVersion.parse((String)SwitchUtil.getMinecraftVersion()).compareTo(SemanticVersion.parse((String)minVersion)) >= 0;
        }
        catch (VersionParsingException e) {
            AutoSwitch.logger.error((Object)e);
            return false;
        }
    }
}

