/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config;

import autoswitch.config.util.CaseInsensitiveEnumConverter;
import autoswitch.config.util.Comment;
import autoswitch.config.util.Permission;
import org.aeonbits.owner.Accessible;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Mutable;
import org.aeonbits.owner.Reloadable;

@Config.HotReload(type=Config.HotReloadType.ASYNC, value=1L)
@Config.Sources(value={"file:${configDir}"})
public interface AutoSwitchConfig
extends Config,
Reloadable,
Accessible,
Mutable {
    @Config.DefaultValue(value="DEFAULT")
    @Config.ConverterClass(value=CaseInsensitiveEnumConverter.class)
    @Comment(value="Controls where and if the keybinding toggle message should be displayed. DEFAULT is above the hotbar, like with bed messages. CHAT is in the chat bar, like a normal chat message. Set to OFF to disable the message entirely.\nAcceptable values: DEFAULT, CHAT, OFF")
    public DisplayControl toggleMessageControl();

    @Config.DefaultValue(value="false")
    @Comment(value="AutoSwitch functionality in creative mode.")
    public Boolean switchInCreative();

    @Config.DefaultValue(value="BOTH")
    @Config.Key(value="switchAllowedFor")
    @Config.ConverterClass(value=CaseInsensitiveEnumConverter.class)
    @Comment(value="Allow switching on the specified type, eg. only switch for blocks by specifying 'BLOCKS'. Set to 'NONE' to disable this behavior entirely.\nAcceptable values: BOTH, MOBS, BLOCKS, NONE")
    public TargetType switchAllowed();

    @Config.DefaultValue(value="true")
    @Comment(value="Allow AutoSwitch when in multiplayer.")
    public Boolean switchInMP();

    @Config.DefaultValue(value="BOTH")
    @Config.ConverterClass(value=CaseInsensitiveEnumConverter.class)
    @Config.Key(value="switchbackAllowedFor")
    @Comment(value="Return to the previous slot when no longer performing the action on the specified type. Set to 'NONE' to disable this behavior entirely.\nAcceptable values: BOTH, MOBS, BLOCKS, NONE")
    public TargetType switchbackAllowed();

    @Config.DefaultValue(value="MOBS")
    @Config.Key(value="switchbackWaitsForCooldown")
    @Config.ConverterClass(value=CaseInsensitiveEnumConverter.class)
    @Comment(value="Before switching back when using the 'attack' action, wait for the attack cooldown to finish. Fixes attacks not doing a lot of damage to mobs, and makes switchback for blocks visually smoother. \nAcceptable values: BOTH, MOBS, BLOCKS, NONE")
    public TargetType switchbackWaits();

    @Config.DefaultValue(value="true")
    @Comment(value="Will ignore tools that are about to break when considering which tool to switch to.")
    public Boolean tryPreserveDamagedTools();

    @Config.DefaultValue(value="SADDLE")
    @Config.ConverterClass(value=CaseInsensitiveEnumConverter.class)
    @Comment(value="Switch used tool to offhand for the specified type.Use 'ALL' to move all items to the offhand. 'SADDLE' will only move the item to the offhand for saddleable targets.\nAcceptable values: ALL, SADDLE, OFF.")
    public OffhandType putUseActionToolInOffHand();

    @Config.DefaultValue(value="true")
    @Comment(value="Switch used tool to offhand if no item is there.")
    public Boolean preserveOffhandItem();

    @Config.DefaultValue(value="true")
    @Comment(value="Switch for use-action of a tool.")
    public Boolean switchUseActions();

    @Config.DefaultValue(value="true")
    @Comment(value="Prefer tool with minimum mining level.")
    public Boolean preferMinimumViableTool();

    @Config.DefaultValue(value="true")
    @Comment(value="Checks if a saddlable entity has a saddle for use action to switch. Does not allow switching to a saddle on hotbar.")
    public Boolean checkSaddlableEntitiesForSaddle();

    @Config.DefaultValue(value="true")
    @Comment(value="Enable check for tool's ability to harvest the targeted block via comparison of mining levels.")
    public Boolean miningLevelCheck();

    @Config.DefaultValue(value="true")
    @Comment(value="Enable switching to items with no durability when no tool is found.")
    public Boolean useNoDurabilityItemsWhenUnspecified();

    @Config.DefaultValue(value="true")
    @Comment(value="Enable to allow target list to stack enchantments. Disable for old behavior. When enabled, a target selector of 'tool;fortune, tool;mending' will prefer a tool with both fortune and mending over one with just fortune. This differs from 'tool;fortune&mending' in that only one enchantment is required for the tool to be selected, rather than both fortune and mending.")
    public Boolean toolEnchantmentsStack();

    @Config.DefaultValue(value="false")
    @Comment(value="This setting is meant to disable config GUI integration if in future the feature breaks, but the rest of AutoSwitch does not. Fallbacks are in place to ensure any changes to Minecraft do not break integration, this is simply a more extreme kill switch.")
    public Boolean disableModMenuConfig();

    @Config.DefaultValue(value="false")
    @Comment(value="Tools with enchantments that increase attack damage will be rated higher. This means an axe with sharpness can be preferred over a sword. Set to true to enable this functionality. False ignores the enchantments.")
    public Boolean weaponRatingIncludesEnchants();

    @Config.DefaultValue(value="false")
    @Comment(value="Will force use of the toggle key in order to enable switching.")
    public Boolean disableSwitchingOnStartup();

    @Config.DefaultValue(value="0.05")
    @Comment(value="Delay in seconds from end of hand swinging to perform switchback action. Resolution on the order of ticks. 0.05 is 1 tick of delay.")
    public Float switchbackDelay();

    @Config.DefaultValue(value="0.05")
    @Comment(value="Delay in seconds from triggering of normal switch action on the basis that the previous switch has not been undone via switchback. Resolution on the order of ticks. 0.05 is 1 tick of delay.")
    public Float switchDelay();

    @Config.DefaultValue(value="true")
    @Comment(value="Ignore tools with 0 energy/durability.")
    public Boolean skipDepletedItems();

    @Config.DefaultValue(value="")
    @Comment(value="No touchy! For checking when to regen config files!")
    public String configVersion();

    @Config.DefaultValue(value="false")
    @Comment(value="When enabled, the config files will be regenerated upon every MC startup. This means any user-added config entries will be moved to the bottom in the 'Overrides' section. When disabled, the files will only be rewritten when the config version does not match expected one. Do note that the material and usable configs will not regenerate if removed with this disabled if the main config was not also removed.")
    public Boolean alwaysRewriteConfigs();

    @Config.DefaultValue(value="true")
    @Comment(value="If enabled, AutoSwitch will attempt to avoid recalculating hotbar slots to be used on a particular target. Each time that slot is modified, it's cached data is thrown out. This can benefit performance.")
    public Boolean cacheSwitchResults();

    @Config.DefaultValue(value="0.25")
    @Comment(value="Prevents switching for 'attack' action on a block for the specified number of seconds after attacking an entity. Resolution on the order of ticks. 0.05 is 1 tick of delay.")
    public Float preventBlockSwitchAfterEntityAttack();

    @Config.DefaultValue(value="true")
    @Comment(value="Enable client-sided commands to modify options in this file, as well to toggle AS on/off during gameplay. Only effective on restart.")
    public Boolean enableConfigCommands();

    public static enum OffhandType implements Permission
    {
        SADDLE,
        ALL,
        OFF{

            @Override
            public boolean allowed() {
                return false;
            }
        };

    }

    public static enum DisplayControl implements Permission
    {
        DEFAULT,
        CHAT,
        OFF{

            @Override
            public boolean allowed() {
                return false;
            }
        };

    }

    public static enum TargetType implements Permission
    {
        BOTH,
        MOBS,
        BLOCKS,
        NONE{

            @Override
            public boolean allowed() {
                return false;
            }
        };

    }
}

