/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.commands;

import autoswitch.AutoSwitch;
import autoswitch.config.AutoSwitchConfig;
import autoswitch.config.commands.CommandGenerator;
import autoswitch.config.commands.GenericCommand;
import autoswitch.config.io.ConfigEstablishment;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class CommandConductor {
    private static final BiFunction<String, Method, Command<FabricClientCommandSource>> configCommandMaker = (name, method) -> context -> {
        AutoSwitch.featureCfg.setProperty((String)name, context.getArgument("option", method.getReturnType()).toString());
        try {
            ConfigEstablishment.writeConfigFiles();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585("Config file updated."));
        }
        catch (IOException e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)new class_2585("Failed to update config file."));
            AutoSwitch.logger.error((Object)e);
            return 1;
        }
        return 0;
    };

    public static void registerAllCommands() {
        if (!AutoSwitch.featureCfg.enableConfigCommands().booleanValue()) {
            return;
        }
        ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"autoswitch_toggle").executes(context -> CommandConductor.changeASToggle((CommandContext<FabricClientCommandSource>)context, !AutoSwitch.doAS)));
        LiteralArgumentBuilder autoswitchCommandBuilder = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"autoswitch").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2585("Commands for changing AutoSwitch's feature config options, except for the tool targets. Please see the config files for complete set of options and documentation. Rewrites the config files."));
            return 1;
        });
        Consumer<GenericCommand> genericCommandConsumer = CommandGenerator.createGeneric2RealCommandConverter((LiteralArgumentBuilder<FabricClientCommandSource>)autoswitchCommandBuilder);
        new CommandGenerator(AutoSwitchConfig.class, configCommandMaker).getCommands().stream().filter(GenericCommand::wasGenerated).forEach(genericCommandConsumer);
        autoswitchCommandBuilder.then(ClientCommandManager.literal((String)"toggleSwitchEnabled").then(ClientCommandManager.argument((String)"allowed", (ArgumentType)BoolArgumentType.bool()).executes(CommandConductor::changeASToggle)));
        ClientCommandManager.DISPATCHER.register(autoswitchCommandBuilder);
    }

    private static int changeASToggle(CommandContext<FabricClientCommandSource> context) {
        return CommandConductor.changeASToggle(context, BoolArgumentType.getBool(context, (String)"allowed"));
    }

    private static int changeASToggle(CommandContext<FabricClientCommandSource> context, boolean newValue) {
        boolean allowed;
        boolean bl = allowed = ((FabricClientCommandSource)context.getSource()).getClient().method_1542() || AutoSwitch.featureCfg.switchInMP() != false;
        if (!allowed) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)new class_2585("Switching is disabled on servers!"));
            return 1;
        }
        String tlKeyTruthy = "msg.autoswitch.toggle_true";
        String tlKeyFalsy = "msg.autoswitch.toggle_false";
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)new class_2588(newValue ? tlKeyTruthy : tlKeyFalsy));
        AutoSwitch.doAS = newValue;
        return 0;
    }
}

