/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.commands;

import autoswitch.config.commands.GenericCommand;
import autoswitch.config.commands.GenericEnumArgument;
import autoswitch.config.util.Comment;
import autoswitch.config.util.ConfigReflection;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandGenerator {
    private final Method[] methods;
    private final BiFunction<String, Method, Command<FabricClientCommandSource>> maker;

    public CommandGenerator(Class<?> clazz, BiFunction<String, Method, Command<FabricClientCommandSource>> maker) {
        this(clazz, maker, false);
    }

    public CommandGenerator(Class<?> clazz, BiFunction<String, Method, Command<FabricClientCommandSource>> maker, boolean allMethods) {
        this.maker = maker;
        this.methods = allMethods ? clazz.getMethods() : clazz.getDeclaredMethods();
    }

    public Set<GenericCommand> getCommands() {
        ObjectArraySet out = new ObjectArraySet();
        for (Method method : this.methods) {
            out.add(CommandGenerator.buildCommandOption(method, this.maker));
        }
        return out;
    }

    private static GenericCommand buildCommandOption(final Method method, final BiFunction<String, Method, Command<FabricClientCommandSource>> maker) {
        return new GenericCommand(){

            @Override
            public ArgumentType<?> argumentType() {
                return CommandGenerator.argumentType(method);
            }

            @Override
            public String name() {
                return ConfigReflection.key(method);
            }

            @Override
            public Command<FabricClientCommandSource> command() {
                return (Command)maker.apply(this.name(), method);
            }

            @Override
            public String failureMessage() {
                Comment c = method.getAnnotation(Comment.class);
                if (c == null) {
                    return "";
                }
                return c.value();
            }
        };
    }

    public static Consumer<GenericCommand> createGeneric2RealCommandConverter(LiteralArgumentBuilder<FabricClientCommandSource> builder) {
        return c -> builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)c.name()).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)new class_2585("Please specify an option."));
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)new class_2585(c.failureMessage()));
            return 1;
        })).then(ClientCommandManager.argument((String)c.paramater(), c.argumentType()).executes(c.command())));
    }

    @Nullable
    public static ArgumentType<?> argumentType(@NotNull Method method) {
        Class<?> clazz = method.getReturnType();
        if (clazz.equals(Boolean.class)) {
            return BoolArgumentType.bool();
        }
        if (clazz.isEnum()) {
            return new GenericEnumArgument(clazz);
        }
        if (clazz.equals(Float.class)) {
            return FloatArgumentType.floatArg();
        }
        if (clazz.equals(Double.class)) {
            return DoubleArgumentType.doubleArg();
        }
        if (clazz.equals(Integer.class)) {
            return IntegerArgumentType.integer();
        }
        if (clazz.equals(String.class)) {
            return StringArgumentType.greedyString();
        }
        return null;
    }
}

