/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.io;

import autoswitch.AutoSwitch;
import autoswitch.api.AutoSwitchMap;
import autoswitch.compat.autoswitch_api.impl.ApiGenUtil;
import autoswitch.config.AutoSwitchAttackActionConfig;
import autoswitch.config.AutoSwitchConfig;
import autoswitch.config.AutoSwitchUseActionConfig;
import autoswitch.config.io.GenerateConfigTemplate;
import autoswitch.config.populator.AutoSwitchMapsGenerator;
import autoswitch.util.SwitchUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.aeonbits.owner.Accessible;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.ConfigFactory;
import org.aeonbits.owner.Mutable;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public final class ConfigEstablishment {
    private static final Path configDir = FabricLoader.getInstance().getConfigDir();
    private static final Path featurePath = configDir.resolve("autoswitch.cfg");
    private static final Path useActionPath = configDir.resolve("autoswitchUseAction.cfg");
    private static final Path attackActionPath = configDir.resolve("autoswitchAttackAction.cfg");
    private static final String configFeature = featurePath.toString();
    private static final String configAttackAction = attackActionPath.toString();
    private static final String configUseAction = useActionPath.toString();

    public static void establishConfigs() {
        if (!useActionPath.toFile().exists() || !attackActionPath.toFile().exists()) {
            ConfigEstablishment.updateOldConfigFiles();
        }
        ConfigFactory.setProperty((String)"configDir", (String)configFeature);
        ConfigFactory.setProperty((String)"configDirMats", (String)configAttackAction);
        ConfigFactory.setProperty((String)"configUsable", (String)configUseAction);
        AutoSwitch.featureCfg = (AutoSwitchConfig)ConfigFactory.create(AutoSwitchConfig.class, (Map[])new Map[0]);
        AutoSwitch.attackActionCfg = (AutoSwitchAttackActionConfig)ConfigFactory.create(AutoSwitchAttackActionConfig.class, (Map[])new Map[0]);
        AutoSwitch.useActionCfg = (AutoSwitchUseActionConfig)ConfigFactory.create(AutoSwitchUseActionConfig.class, (Map[])new Map[0]);
        ConfigEstablishment.mergeConfigs(AutoSwitch.switchData.attackConfig, AutoSwitch.attackActionCfg);
        ConfigEstablishment.mergeConfigs(AutoSwitch.switchData.usableConfig, AutoSwitch.useActionCfg);
        try {
            String currentVersion = SwitchUtil.getAutoSwitchVersion();
            String configVersion = AutoSwitch.featureCfg.configVersion();
            if (AutoSwitch.featureCfg.alwaysRewriteConfigs().booleanValue() || !configVersion.equals(currentVersion)) {
                AutoSwitch.featureCfg.setProperty("configVersion", currentVersion);
                ConfigEstablishment.writeConfigFiles();
            }
        }
        catch (IOException e) {
            AutoSwitch.logger.error("AutoSwitch failed to obtain the configs during writing!");
            AutoSwitch.logger.error((Object)e);
        }
        AutoSwitch.attackActionCfg.addReloadListener(event -> {
            AutoSwitch.switchState.switchActionCache.clear();
            AutoSwitch.switchData.target2AttackActionToolSelectorsMap.clear();
            AutoSwitchMapsGenerator.populateAutoSwitchMaps();
            AutoSwitch.logger.info("Attack Config Reloaded");
        });
        AutoSwitch.useActionCfg.addReloadListener(event -> {
            AutoSwitch.switchState.switchInteractCache.clear();
            AutoSwitch.switchData.target2UseActionToolSelectorsMap.clear();
            AutoSwitchMapsGenerator.populateAutoSwitchMaps();
            AutoSwitch.logger.info("Interact Config Reloaded");
        });
        AutoSwitch.featureCfg.addReloadListener(event -> {
            AutoSwitch.switchState.switchInteractCache.clear();
            AutoSwitch.switchState.switchActionCache.clear();
            AutoSwitch.logger.info("Feature Config Reloaded");
        });
    }

    private static void updateOldConfigFiles() {
        try {
            FileUtils.moveFile((File)useActionPath.resolveSibling("autoswitchUsable.cfg").toFile(), (File)useActionPath.toFile());
            FileUtils.moveFile((File)attackActionPath.resolveSibling("autoswitchMaterials.cfg").toFile(), (File)attackActionPath.toFile());
            ConfigEstablishment.updateOldConfigFormat(attackActionPath.toFile());
            ConfigEstablishment.updateOldConfigFormat(useActionPath.toFile());
        }
        catch (IOException e) {
            AutoSwitch.logger.catching(Level.DEBUG, (Throwable)e);
        }
    }

    private static <T extends Mutable & Accessible> void mergeConfigs(AutoSwitchMap<String, String> api, T cfg) {
        api.forEach((k, v) -> {
            if (((Accessible)cfg).getProperty(k) == null) {
                cfg.setProperty(k, v);
            }
        });
    }

    public static void writeConfigFiles() throws IOException {
        ConfigEstablishment.genFile(configFeature, AutoSwitch.featureCfg, "AutoSwitch Configuration File\nSee https://github.com/dexman545/Fabric-Autoswitch/wiki/Configuration for more details.\nSetting an option to 'true' will enable it's stated behavior; using 'false' will disable it.", null);
        ConfigEstablishment.genFile(configAttackAction, AutoSwitch.attackActionCfg, "AutoSwitch Material Configuration File\nFormat is a comma separated list of 'tool selectors', which take the form of 'toolname[;enchantment list]',  where toolname is either a ToolGrouping, or a specific item id with same formatting rules as enchantments. \nEnchant list is optional. If present, it must be separated from the tool by a semicolon (';'). Enchantment list is a list of `enchantment id`s separated by `&`, such as 'minecraft!fortune&minecraft!mending'. The list can have infinite enchantments. If multiple enchantments are specified, only tools with *all* of the enchantments will be selected. Use multiple tool selectors to specify optional enchantments. See toolEnchantmentsStack in autoswitch.cfg. \nEnchant and item id uses '!' instead of colons. A colon can be used as long as it is on the right of the equal sign.\nExample: minecraft!stick;minecraft!fortune \nList is ordered and will affect tool selection. \nYou can add block/mob-specific overrides by adding it's id (replacing colon with '\\:' or '!') on a new line and adding values to the right of \nthe equals sign ('=') as you would normally. Check the boat for an example. \nRemoving the values after the equals sign will disable the switch. In the case of overrides, the line may be removed for default behavior.\nIf you would like to write config values across multiple lines, use a '\\', followed by a new line. See https://stackoverflow.com/a/8978515\nTechnical details of config files: https://github.com/dexman545/Fabric-Autoswitch/wiki/Config-Details", ApiGenUtil.modActionConfigs);
        ConfigEstablishment.genFile(configUseAction, AutoSwitch.useActionCfg, "AutoSwitch Usable Configuration File\nThis file defines tool switching targets for the 'use' action (right clicking) on a mob or block. \nSame format as the Material Config:\nFormat is a comma separated list of 'tool selectors', which take the form of 'toolname[;enchantment list]',  where toolname is either a ToolGrouping, or a specific item id with same formatting rules as enchantments. \nEnchant list is optional. If present, it must be separated from the tool by a semicolon (';'). Enchantment list is a list of `enchantment id`s separated by `&`, such as 'minecraft!fortune&minecraft!mending'. The list can have infinite enchantments. If multiple enchantments are specified, only tools with *all* of the enchantments will be selected. Use multiple tool selectors to specify optional enchantments. See toolEnchantmentsStack in autoswitch.cfg. \nEnchant and item id uses '!' instead of colons. A colon can be used as long as it is on the right of the equal sign.\nExample: minecraft!stick;minecraft!fortune \nList is ordered and will affect tool selection. \nYou can add block/mob-specific overrides by adding it's id (replacing colon with '\\:' or '!') on a new line and adding values to the right of \nthe equals sign ('=') as you would normally. Check the boat for an example. \nRemoving the values after the equals sign will disable the switch. In the case of overrides, the line may be removed for default behavior.\nIf you would like to write config values across multiple lines, use a '\\', followed by a new line. See https://stackoverflow.com/a/8978515\nTechnical details of config files: https://github.com/dexman545/Fabric-Autoswitch/wiki/Config-Details", ApiGenUtil.modUseConfigs);
    }

    private static void updateOldConfigFormat(File file) throws IOException {
        String s = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8).replaceAll("minecraft-", "minecraft!");
        FileUtils.writeStringToFile((File)file, (String)s, (Charset)StandardCharsets.UTF_8, (boolean)false);
    }

    private static <T extends Accessible & Config> void genFile(String path, T config, String header, Object2ObjectOpenHashMap<String, Set<String>> moddedEntries) throws IOException {
        FileOutputStream basicConfig = new FileOutputStream(path);
        basicConfig.write(GenerateConfigTemplate.initConfig(config, moddedEntries, header).getBytes());
        basicConfig.close();
    }
}

