/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.io;

import autoswitch.config.AutoSwitchAttackActionConfig;
import autoswitch.config.AutoSwitchUseActionConfig;
import autoswitch.config.util.ConfigReflection;
import autoswitch.config.util.ConfigTemplates;
import autoswitch.config.util.SortedProperties;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.aeonbits.owner.Accessible;
import org.aeonbits.owner.Config;

public class GenerateConfigTemplate {
    public static <T extends Config & Accessible> String initConfig(T cfg, Object2ObjectOpenHashMap<String, Set<String>> moddedEntries, String header) {
        if (header == null) {
            header = "";
        }
        header = !(header = ConfigTemplates.wordWrapComment(header)).isEmpty() ? "# " + header + "\n\n" : "";
        StringBuilder config = new StringBuilder(header);
        SortedProperties comments = new SortedProperties(new Properties());
        SortedProperties defaults = new SortedProperties(new Properties());
        ConfigReflection.defaults(defaults, Objects.requireNonNull(ConfigReflection.getClass(cfg)));
        ConfigReflection.comments(comments, Objects.requireNonNull(ConfigReflection.getClass(cfg)));
        GenerateConfigTemplate.sanitize(defaults);
        GenerateConfigTemplate.sanitize(comments);
        if (cfg instanceof AutoSwitchUseActionConfig || cfg instanceof AutoSwitchAttackActionConfig) {
            config.append(ConfigTemplates.toolGroupings());
            config.append("\n");
        }
        for (String propertyName : defaults.stringPropertyNames()) {
            String entry = ConfigTemplates.configEntry(propertyName.replaceAll("(?<!\\\\)(?:\\\\{2})*:", "\\\\:"), ((Accessible)cfg).getProperty(propertyName), "# " + comments.getProperty(propertyName), defaults.getProperty(propertyName)) + "\n";
            config.append(entry);
        }
        if (moddedEntries != null) {
            moddedEntries.forEach((mod, keys) -> {
                config.append(ConfigTemplates.modCategory(mod)).append("\n\n");
                for (String key : keys) {
                    config.append(ConfigTemplates.configEntry(key.replaceAll("(?<!\\\\)(?:\\\\{2})*:", "\\\\:"), ((Accessible)cfg).getProperty(key), null, null)).append("\n");
                }
            });
        }
        Properties cfgProp = new Properties();
        ((Accessible)cfg).fill((Map)cfgProp);
        Set<Object> userKeys = GenerateConfigTemplate.diffMaps(defaults, cfgProp);
        if (userKeys != null) {
            config.append("\n# Overrides").append("\n").append(ConfigTemplates.border).append("\n");
            for (Object key : userKeys) {
                config.append(ConfigTemplates.configEntry(((String)key).replaceAll("(?<!\\\\)(?:\\\\{2})*:", "\\\\:"), ((Accessible)cfg).getProperty((String)key), null, null)).append("\n");
            }
        }
        return config.toString();
    }

    private static void sanitize(Properties prop) {
        for (String propertyName : prop.stringPropertyNames()) {
            String newKey;
            if (propertyName.equals(newKey = propertyName.replaceAll("(?<!\\\\)(?:\\\\{2})*:", "\\:"))) continue;
            prop.put(newKey, prop.get(propertyName));
            prop.remove(propertyName);
        }
    }

    private static Set<Object> diffMaps(Properties base, Properties modded) {
        if (!base.equals(modded)) {
            MapDifference diff = Maps.difference((Map)base, (Map)modded);
            return diff.entriesOnlyOnRight().keySet();
        }
        return null;
    }
}

