/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.io;

import autoswitch.AutoSwitch;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public class ToolHandler {
    private int id = 0;

    public ToolHandler(String input) {
        if (AutoSwitch.switchData.toolSelectorKeys.containsKey((Object)input)) {
            this.id = AutoSwitch.switchData.toolSelectorKeys.getInt((Object)input);
            return;
        }
        String[] cleanedInput = input.split(";");
        String tagStr = cleanedInput[0].toLowerCase(Locale.ENGLISH).trim().replace("!", ":");
        String enchantStr = cleanedInput.length > 1 ? cleanedInput[1].toLowerCase(Locale.ENGLISH).trim().replace("!", ":") : "";
        ReferenceArrayList enchants = new ReferenceArrayList();
        ReferenceArrayList enchantIdentifiers = new ReferenceArrayList();
        if (!enchantStr.equals("")) {
            String[] multiEnch;
            for (String ench : multiEnch = enchantStr.split("&")) {
                enchantIdentifiers.add((Object)class_2960.method_12829((String)ench));
            }
        }
        if (this.getTool(tagStr).equals("")) {
            AutoSwitch.logger.debug("Empty Tool Entry tried to parse");
        } else {
            this.id = input.hashCode();
            while (AutoSwitch.switchData.toolSelectorKeys.containsValue(this.id)) {
                ++this.id;
                AutoSwitch.logger.error("Conflicting ID generated for toolselector: {}, attempting to fix...", (Object)input);
            }
            AutoSwitch.switchData.toolSelectorKeys.put((Object)input, this.id);
            enchantIdentifiers.forEach(identifier -> {
                if (!class_2378.field_11160.method_10250(identifier)) {
                    if (!enchantStr.equals("")) {
                        AutoSwitch.logger.warn("An enchantment was not found in registry: " + enchantStr);
                    }
                } else {
                    enchants.add((Object)((class_1887)class_2378.field_11160.method_10223(identifier)));
                }
            });
            AutoSwitch.logger.debug("Adding item to toolmap... " + input);
            AutoSwitch.switchData.toolSelectors.put(this.id, (Object)Pair.of((Object)tagStr, (Object)enchants));
        }
    }

    private String getTool(String t) {
        return class_2960.method_12829((String)t) != null ? t : "";
    }

    public int getId() {
        return this.id;
    }
}

