/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.populator;

import autoswitch.AutoSwitch;
import autoswitch.config.io.MaterialHandler;
import autoswitch.config.io.ToolHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.aeonbits.owner.Accessible;

@Environment(value=EnvType.CLIENT)
public class AutoSwitchMapsGenerator {
    public static void populateAutoSwitchMaps() {
        AutoSwitchMapsGenerator.populateToolTargetMaps();
        AutoSwitch.switchData.toolSelectors.trim();
        AutoSwitch.switchData.target2UseActionToolSelectorsMap.trim();
        AutoSwitch.switchData.target2AttackActionToolSelectorsMap.trim();
    }

    private static void populateToolTargetMaps() {
        AutoSwitchMapsGenerator.populateMap(AutoSwitch.switchData.target2AttackActionToolSelectorsMap, AutoSwitch.attackActionCfg);
        AutoSwitchMapsGenerator.populateMap(AutoSwitch.switchData.target2UseActionToolSelectorsMap, AutoSwitch.useActionCfg);
    }

    private static void populateMap(Object2ObjectOpenHashMap<Object, IntArrayList> map, Accessible cfg) {
        for (String key : cfg.propertyNames()) {
            String raw = cfg.getProperty(key);
            String[] split = raw.split(",");
            IntArrayList list = new IntArrayList();
            for (String input : split) {
                int x = new ToolHandler(input).getId();
                if (x == 0) continue;
                list.add(x);
            }
            AutoSwitch.switchData.targets.computeIfAbsent((Object)key, k -> new MaterialHandler((String)k).getMat());
            if (list.isEmpty() || !AutoSwitch.switchData.targets.containsKey((Object)key)) continue;
            map.put(AutoSwitch.switchData.targets.get((Object)key), (Object)list);
        }
    }
}

