/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.util;

import autoswitch.AutoSwitch;
import java.lang.reflect.Method;
import java.util.Locale;
import org.aeonbits.owner.Converter;
import org.jetbrains.annotations.Nullable;

public class CaseInsensitiveEnumConverter<X extends Enum<X>>
implements Converter<X> {
    public X convert(Method method, String input) {
        Class<?> t = method.getReturnType();
        Object e = CaseInsensitiveEnumConverter.searchEnum(t, input.toUpperCase(Locale.ENGLISH));
        if (e == null) {
            AutoSwitch.logger.error("Could not parse value: {} on {}; Defaulting to another.", (Object)input, (Object)method.getName());
            return (X)((Enum[])t.getEnumConstants())[0];
        }
        return (X)e;
    }

    @Nullable
    private static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (each.name().compareToIgnoreCase(search) != 0) continue;
            return (T)each;
        }
        return null;
    }
}

