/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.util;

import autoswitch.AutoSwitch;
import autoswitch.config.AutoSwitchAttackActionConfig;
import autoswitch.config.AutoSwitchConfig;
import autoswitch.config.AutoSwitchUseActionConfig;
import autoswitch.config.util.Comment;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.aeonbits.owner.Config;

public class ConfigReflection {
    private static final ObjectArrayList<Class<? extends Config>> configClasses = new ObjectArrayList();

    public static Class<? extends Config> getClass(Object o) {
        for (Class configClass : configClasses) {
            if (!configClass.isInstance(o)) continue;
            return configClass;
        }
        AutoSwitch.logger.error("Attempted to gen. config template for an unknown config class!");
        return null;
    }

    public static void defaults(Map<String, String> properties, Class<? extends Config> clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            String key = ConfigReflection.key(method);
            String value = ConfigReflection.defaultValue(method);
            if (value == null) continue;
            properties.put(key, value);
        }
    }

    public static <T extends AccessibleObject> String key(T accessibleMember) {
        Config.Key key = ((AccessibleObject)accessibleMember).getAnnotation(Config.Key.class);
        return key == null ? ((Member)accessibleMember).getName() : key.value().replaceAll("(?<!\\\\)(?:\\\\{2})*:", "\\:");
    }

    private static String defaultValue(AccessibleObject accessibleObject) {
        Config.DefaultValue defaultValue = accessibleObject.getAnnotation(Config.DefaultValue.class);
        return defaultValue != null ? defaultValue.value() : null;
    }

    public static void defaults(Properties properties, Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String key = ConfigReflection.key(field);
            String value = ConfigReflection.defaultValue(field);
            if (value == null) continue;
            properties.put(key, value);
        }
    }

    public static void comments(Properties properties, Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String key = ConfigReflection.key(field);
            String value = ConfigReflection.comment(field);
            if (value == null) continue;
            properties.put(key, value);
        }
    }

    private static String comment(AccessibleObject accessibleObject) {
        Comment comment = accessibleObject.getAnnotation(Comment.class);
        return comment != null ? comment.value() : null;
    }

    static {
        configClasses.add(AutoSwitchAttackActionConfig.class);
        configClasses.add(AutoSwitchConfig.class);
        configClasses.add(AutoSwitchUseActionConfig.class);
    }
}

