/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.config.util;

import autoswitch.AutoSwitch;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang3.text.WordUtils;

public class ConfigTemplates {
    private static final int width = 120;
    private static final String commentChar = "#";
    public static final String border = Strings.repeat((String)"#", (int)120);
    private static final String baseCommentedText = "# <FILL> #";
    private static final String modCategoryDescription = "Config Entries Provided by: ";
    private static final String defaultValueComment = "\n# Default Value: ";
    private static final String deliminatorPreserver = "((?<=%1$s)|(?=%1$s))";

    public static String modCategory(String modName) {
        return ConfigTemplates.category(modName, modCategoryDescription, new String[0]);
    }

    private static String category(String name, String categoryDesc, String ... info) {
        String title = categoryDesc + name;
        if (title.length() < 116) {
            title = ConfigTemplates.centeredString(title);
            title = title + Strings.repeat((String)" ", (int)(120 - title.length() - 4));
        }
        if (info != null) {
            ArrayList<String> out = new ArrayList<String>();
            out.add(border);
            out.add(baseCommentedText.replace("<FILL>", title));
            for (String s : info) {
                if (s.length() >= 116) continue;
                s = ConfigTemplates.centeredString(s);
                s = s + Strings.repeat((String)" ", (int)(120 - s.length() - 4));
                out.add(baseCommentedText.replace("<FILL>", s));
            }
            out.add(border);
            String[] a = new String[out.size()];
            return ConfigTemplates.combineToBlock(out.toArray(a));
        }
        return ConfigTemplates.combineToBlock(border, baseCommentedText.replace("<FILL>", title), border);
    }

    private static String centeredString(String input) {
        int centering = (int)Math.ceil((float)(120 - input.length() - 4) / 2.0f);
        return Strings.repeat((String)" ", (int)centering) + input;
    }

    private static String combineToBlock(String ... strings) {
        StringBuilder out = new StringBuilder();
        for (String string : strings) {
            out.append(string).append("\n");
        }
        out.delete(out.length() - 1, out.length());
        return out.toString();
    }

    public static String configEntry(String key, String value, String comment, String defaultValue) {
        return ConfigTemplates.configEntry(key, value, comment, defaultValue, false);
    }

    public static String configEntry(String key, String value, String comment, String defaultValue, boolean doWrap) {
        return ConfigTemplates.configEntry(ConfigTemplates.configValueEntry(key, value, doWrap), comment, defaultValue);
    }

    private static String configEntry(String cfg, String comment, String defaultValue) {
        StringBuilder out = new StringBuilder();
        if (comment != null && !comment.equals("")) {
            out.append("\n");
            out.append(ConfigTemplates.wordWrapComment(comment));
        }
        out.append(ConfigTemplates.configCommentEntry(defaultValue));
        return ConfigTemplates.combineToBlock(out.toString(), cfg);
    }

    private static String configValueEntry(String key, String value, boolean doWrap) {
        if (value == null) {
            value = "";
        }
        key = key.replaceAll("(?<!\\\\)(?:\\\\{2})*:", "\\:");
        return doWrap ? ConfigTemplates.configValueEntryWordwrap(key + " = " + value) : key + " = " + value;
    }

    public static String wordWrapComment(String str) {
        String[] cls;
        StringBuilder out = new StringBuilder();
        for (String cl : cls = str.replaceAll("\n", "\n# ").split(String.format(deliminatorPreserver, "\n"))) {
            out.append(WordUtils.wrap((String)cl, (int)118, (String)"\n# ", (boolean)false));
        }
        return out.toString();
    }

    private static String configCommentEntry(String defaultValue) {
        return defaultValue != null && !defaultValue.equals("") ? defaultValueComment + defaultValue : "";
    }

    private static String configValueEntryWordwrap(String str) {
        return WordUtils.wrap((String)str, (int)118, (String)", \\\n", (boolean)false, (String)",");
    }

    public static String toolGroupings() {
        StringBuilder keys = new StringBuilder();
        Enumeration enumKeys = AutoSwitch.switchData.toolGroupings.keys();
        while (enumKeys.hasMoreElements()) {
            keys.append(keys.length() > 0 ? ", " : "").append((String)enumKeys.nextElement());
        }
        return ConfigTemplates.category("Provided Tool Groupings by AutoSwitch and Mods it Interfaced With", "", "Tool groupings are a way to specify multiple tools at once. To match any grouping, use 'any'.", keys.toString());
    }

    private static String configValueEntry(String key, String value) {
        return ConfigTemplates.configValueEntry(key, value, false);
    }
}

