/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.events;

import autoswitch.events.SwitchEvent;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class Scheduler {
    private final Set<Task> schedule = new CopyOnWriteArraySet<Task>();

    public void schedule(SwitchEvent event, double deltaTimeSec, int initTickTime) {
        int deltaTimeTicks = (int)Math.floor(deltaTimeSec * 20.0);
        this.remove(event);
        this.schedule.add(new Task(event, initTickTime + deltaTimeTicks));
    }

    public void execute(int currentTick) {
        this.schedule.forEach(task -> {
            if (((Task)task).finalTickTime <= currentTick && ((Task)task).event.handlePreSwitchTasks() && ((Task)task).event.invoke()) {
                this.schedule.remove(task);
            }
        });
    }

    public void resetSchedule() {
        this.schedule.clear();
    }

    protected void remove(SwitchEvent event) {
        this.schedule.forEach(task -> {
            if (((Task)task).event.equals((Object)event)) {
                this.schedule.remove(task);
            }
        });
    }

    public boolean isEventScheduled(SwitchEvent event) {
        return this.schedule.stream().anyMatch(task -> ((Task)task).event.equals((Object)event));
    }

    private static class Task {
        private final int finalTickTime;
        private final SwitchEvent event;

        private Task(SwitchEvent event, int finalTickTime) {
            this.event = event;
            this.finalTickTime = finalTickTime;
        }

        public String toString() {
            return "Task{finalTickTime=" + this.finalTickTime + ", event=" + (Object)((Object)this.event) + '}';
        }
    }
}

