/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.events;

import autoswitch.AutoSwitch;
import autoswitch.config.AutoSwitchConfig;
import autoswitch.mixin.mixins.PlayerEntityAccessor;
import autoswitch.targetable.Targetable;
import autoswitch.util.EventUtil;
import autoswitch.util.SwitchState;
import autoswitch.util.SwitchUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2680;
import net.minecraft.class_5146;
import org.jetbrains.annotations.Contract;

public enum SwitchEvent {
    ATTACK{

        private void handlePostSwitchTasks(boolean hasSwitched) {
            if (hasSwitched) {
                boolean doSwitchBack;
                boolean bl = doSwitchBack = AutoSwitch.featureCfg.switchbackAllowed() == AutoSwitchConfig.TargetType.BOTH;
                if (protoTarget instanceof class_1297) {
                    if (doSwitchBack || AutoSwitch.featureCfg.switchbackAllowed() == AutoSwitchConfig.TargetType.MOBS) {
                        AutoSwitch.switchState.setHasSwitched(true);
                        AutoSwitch.switchState.setAttackedEntity(true);
                    }
                } else if (protoTarget instanceof class_2680 && (doSwitchBack || AutoSwitch.featureCfg.switchbackAllowed() == AutoSwitchConfig.TargetType.BLOCKS)) {
                    AutoSwitch.switchState.setHasSwitched(true);
                }
                EventUtil.eventHandler(AutoSwitch.tickTime, AutoSwitch.featureCfg.switchbackDelay().floatValue(), SWITCHBACK);
            }
        }

        @Override
        public boolean invoke() {
            if (this.canNotSwitch()) {
                return false;
            }
            this.handlePrevSlot();
            Targetable.attack(protoTarget, player).changeTool().ifPresent(this::handlePostSwitchTasks);
            return true;
        }
    }
    ,
    USE{

        private boolean doOffhand() {
            if (AutoSwitch.featureCfg.putUseActionToolInOffHand() == AutoSwitchConfig.OffhandType.SADDLE) {
                return protoTarget instanceof class_5146;
            }
            return AutoSwitch.featureCfg.putUseActionToolInOffHand().allowed();
        }

        private void handlePostSwitchTasks(boolean hasSwitched) {
            doOffhandSwitch = this.doOffhand();
            AutoSwitch.switchState.setHasSwitched(hasSwitched);
            if (hasSwitched) {
                EventUtil.eventHandler(AutoSwitch.tickTime, 0.1, OFFHAND);
                EventUtil.eventHandler(AutoSwitch.tickTime, AutoSwitch.featureCfg.switchbackDelay().floatValue(), SWITCHBACK);
            }
        }

        @Override
        public boolean invoke() {
            if (this.canNotSwitch()) {
                return false;
            }
            this.handlePrevSlot();
            Targetable.use(protoTarget, player).changeTool().ifPresent(this::handlePostSwitchTasks);
            return true;
        }
    }
    ,
    SWITCHBACK{

        @Override
        protected boolean canNotSwitch() {
            if (AutoSwitch.switchState.getHasSwitched() && !3.player.field_6252) {
                return SwitchState.preventBlockAttack || (this.doBlockSwitchback() || this.doMobSwitchback()) && this.doSwitchback();
            }
            return true;
        }

        @Contract(pure=true)
        private boolean doSwitchback() {
            return player.method_7261(-20.0f) != 1.0f;
        }

        @Contract(pure=true)
        private boolean doMobSwitchback() {
            return AutoSwitch.switchState.hasAttackedEntity() && (AutoSwitch.featureCfg.switchbackWaits() == AutoSwitchConfig.TargetType.BOTH || AutoSwitch.featureCfg.switchbackWaits() == AutoSwitchConfig.TargetType.MOBS);
        }

        @Contract(pure=true)
        private boolean doBlockSwitchback() {
            return !AutoSwitch.switchState.hasAttackedEntity() && (AutoSwitch.featureCfg.switchbackWaits() == AutoSwitchConfig.TargetType.BOTH || AutoSwitch.featureCfg.switchbackWaits() == AutoSwitchConfig.TargetType.BLOCKS);
        }

        private void handlePostSwitchTasks(boolean hasSwitched) {
            if (hasSwitched) {
                AutoSwitch.switchState.setHasSwitched(false);
                AutoSwitch.switchState.setAttackedEntity(false);
            }
        }

        @Override
        public boolean invoke() {
            if (this.canNotSwitch()) {
                return false;
            }
            Targetable.switchback(AutoSwitch.switchState.getPrevSlot(), player).changeTool().ifPresent(this::handlePostSwitchTasks);
            return true;
        }
    }
    ,
    OFFHAND{

        @Override
        public boolean invoke() {
            SwitchUtil.handleUseSwitchConsumer().accept(doOffhandSwitch);
            doOffhandSwitch = false;
            EventUtil.eventHandler(AutoSwitch.tickTime, 0.1, SWITCHBACK);
            return true;
        }
    }
    ,
    PREVENT_BLOCK_ATTACK{

        @Override
        public boolean invoke() {
            float delay = AutoSwitch.featureCfg.preventBlockSwitchAfterEntityAttack().floatValue();
            if (delay == 0.0f) {
                return true;
            }
            SwitchState.preventBlockAttack = AutoSwitch.scheduler.isEventScheduled(PREVENT_BLOCK_ATTACK);
            if (SwitchState.preventBlockAttack) {
                AutoSwitch.scheduler.schedule(REMOVE_PREVENTION, delay, AutoSwitch.tickTime);
            }
            return true;
        }
    }
    ,
    REMOVE_PREVENTION{

        @Override
        public boolean invoke() {
            AutoSwitch.scheduler.remove(PREVENT_BLOCK_ATTACK);
            SwitchState.preventBlockAttack = false;
            return true;
        }
    };

    public static class_1657 player;
    private static Object protoTarget;
    private static boolean doSwitchType;
    private static boolean doSwitch;
    private static boolean doOffhandSwitch;

    public abstract boolean invoke();

    boolean canNotSwitch() {
        return !doSwitch || !doSwitchType;
    }

    void handlePrevSlot() {
        if (!AutoSwitch.switchState.getHasSwitched()) {
            AutoSwitch.switchState.setPrevSlot(((PlayerEntityAccessor)SwitchEvent.player).getInventory().field_7545);
        }
    }

    public boolean handlePreSwitchTasks() {
        return true;
    }

    public SwitchEvent setProtoTarget(Object protoTarget) {
        SwitchEvent.protoTarget = protoTarget;
        return this;
    }

    public SwitchEvent setPlayer(class_1657 player) {
        SwitchEvent.player = player;
        return this;
    }

    public SwitchEvent setDoSwitchType(boolean doSwitchType) {
        SwitchEvent.doSwitchType = doSwitchType;
        return this;
    }

    public SwitchEvent setDoSwitch(boolean doAS) {
        doSwitch = doAS;
        return this;
    }
}

