/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.mixin.impl;

import autoswitch.AutoSwitch;
import autoswitch.util.TargetableCache;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;

public class HotbarWatcher {
    public static void handleSlotChange(List<class_1799> prev, List<class_1799> current) {
        HotbarWatcher.updateCaches(HotbarWatcher.compareHotbars(prev, current));
    }

    public static void updateCaches(IntArrayList changedSlots) {
        changedSlots.forEach(slot -> {
            HotbarWatcher.updateCache(AutoSwitch.switchState.switchActionCache, slot);
            HotbarWatcher.updateCache(AutoSwitch.switchState.switchInteractCache, slot);
        });
    }

    public static IntArrayList compareHotbars(List<class_1799> prev, List<class_1799> current) {
        IntArrayList changedHotbarSlots = new IntArrayList(class_1661.method_7368());
        if (prev == null || current == null) {
            return changedHotbarSlots;
        }
        for (int slot = 0; slot < prev.size(); ++slot) {
            class_1799 nStack;
            class_1799 oStack = prev.get(slot);
            if (!HotbarWatcher.stacksSufficientlyDiffer(oStack, nStack = current.get(slot))) continue;
            changedHotbarSlots.add(slot);
        }
        return changedHotbarSlots;
    }

    private static void updateCache(TargetableCache cache, int slot) {
        cache.clear();
    }

    private static boolean stacksSufficientlyDiffer(class_1799 o, class_1799 n) {
        if (o.method_7960() || n.method_7960()) {
            return true;
        }
        if (class_1799.method_7973((class_1799)o, (class_1799)n)) {
            return false;
        }
        return !class_1799.method_7975((class_1799)o, (class_1799)n) || !class_1799.method_7987((class_1799)o, (class_1799)n);
    }
}

