/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.targetable;

import autoswitch.AutoSwitch;
import autoswitch.mixin.mixins.PlayerEntityAccessor;
import autoswitch.targetable.TargetableAttack;
import autoswitch.targetable.TargetableNone;
import autoswitch.targetable.TargetableUsable;
import autoswitch.util.SwitchData;
import autoswitch.util.TargetableUtil;
import it.unimi.dsi.fastutil.ints.Int2DoubleArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public abstract class Targetable {
    private final Int2DoubleArrayMap slot2ToolRating = new Int2DoubleArrayMap();
    Object protoTarget = null;
    class_1657 player;

    protected Targetable(class_1657 player) {
        this.player = player;
    }

    public static Targetable use(Object protoTarget, class_1657 player) {
        return new TargetableUsable(player, protoTarget);
    }

    public static Targetable switchback(int prevSlot, class_1657 player) {
        return new TargetableNone(prevSlot, player);
    }

    public static Targetable attack(Object protoTarget, class_1657 player) {
        return new TargetableAttack(protoTarget, player);
    }

    void populateToolLists() {
        List hotbar = ((PlayerEntityAccessor)this.player).getInventory().field_7547.subList(0, class_1661.method_7368());
        for (int slot = 0; slot < class_1661.method_7368(); ++slot) {
            if (TargetableUtil.skipSlot((class_1799)hotbar.get(slot))) continue;
            this.populateToolSelection((class_1799)hotbar.get(slot), slot);
        }
    }

    abstract void populateToolSelection(class_1799 var1, int var2);

    public Optional<Boolean> changeTool() {
        return this.findSlot().map(slot -> {
            int currentSlot = ((PlayerEntityAccessor)this.player).getInventory().field_7545;
            if (slot == currentSlot) {
                return false;
            }
            ((PlayerEntityAccessor)this.player).getInventory().field_7545 = slot;
            return true;
        });
    }

    Optional<Integer> findSlot() {
        if (!this.switchAllowed().booleanValue() || this.slot2ToolRating.isEmpty()) {
            return Optional.empty();
        }
        AutoSwitch.logger.debug((Object)this.slot2ToolRating);
        if (!this.slot2ToolRating.isEmpty()) {
            int slot = Collections.max(this.slot2ToolRating.int2DoubleEntrySet(), Comparator.comparingDouble(Map.Entry::getValue)).getIntKey();
            if (AutoSwitch.featureCfg.cacheSwitchResults().booleanValue()) {
                TargetableUtil.getTargetableCache(AutoSwitch.switchState, this.isUse()).put(this.protoTarget, slot);
            }
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    private Boolean switchAllowed() {
        return !(this.player.method_7337() && AutoSwitch.featureCfg.switchInCreative() == false || this.switchTypeAllowed() == false || !class_310.method_1551().method_1542() && AutoSwitch.featureCfg.switchInMP() == false);
    }

    boolean isUse() {
        return false;
    }

    abstract Boolean switchTypeAllowed();

    void processToolSelectors(class_1799 stack, int slot, Object2ObjectOpenHashMap<Object, IntArrayList> toolSelectorMap, TargetGetter targetGetter, ToolSelector toolSelector) {
        if (!this.switchAllowed().booleanValue()) {
            return;
        }
        OptionalInt cachedSlot = TargetableUtil.getCachedSlot(this.protoTarget, AutoSwitch.switchState, this.isUse());
        if (cachedSlot.isPresent()) {
            this.slot2ToolRating.put(cachedSlot.getAsInt(), 100.0);
            return;
        }
        class_1792 item = stack.method_7909();
        AtomicReference<Float> counter = new AtomicReference<Float>(Float.valueOf((float)class_1661.method_7368() * 10.0f));
        Object target = targetGetter.getTarget(this.protoTarget);
        if (target == null || this.checkSpecialCase(target)) {
            return;
        }
        ((IntArrayList)toolSelectorMap.getOrDefault(target, (Object)SwitchData.blank)).forEach(id -> {
            ReferenceArrayList enchants;
            String tool;
            if (id == 0) {
                return;
            }
            counter.updateAndGet(v -> Float.valueOf((float)((double)v.floatValue() - 0.75)));
            if (id != SwitchData.blank.getInt(0)) {
                Pair pair = (Pair)AutoSwitch.switchData.toolSelectors.get(id);
                tool = (String)pair.getLeft();
                enchants = (ReferenceArrayList)pair.getRight();
            } else {
                tool = "blank";
                enchants = null;
            }
            if (toolSelector.correctType(tool, item) && (this.isUse() || TargetableUtil.isRightTool(stack, this.protoTarget))) {
                this.updateToolListsAndRatings(stack, tool, (ReferenceArrayList<class_1887>)enchants, slot, counter);
            }
        });
    }

    private void updateToolListsAndRatings(class_1799 stack, String tool, ReferenceArrayList<class_1887> enchants, int slot, AtomicReference<Float> counter) {
        double rating = 0.0;
        boolean stackEnchants = true;
        if (enchants == null) {
            rating += 1.0;
            stackEnchants = false;
        } else {
            double enchantRating = 0.0;
            for (class_1887 enchant : enchants) {
                double d;
                enchantRating += 1.1 * (double)class_1890.method_8225((class_1887)enchant, (class_1799)stack);
                if (!(d <= 0.0)) continue;
                return;
            }
            rating += enchantRating;
            AutoSwitch.logger.debug("Slot: {}; EnchantRating: {}", (Object)slot, (Object)enchantRating);
        }
        if (!this.isUse()) {
            if (AutoSwitch.featureCfg.preferMinimumViableTool().booleanValue() && rating != 0.0) {
                rating += -1.0 * Math.log10(rating);
            }
            rating += (double)(TargetableUtil.getTargetRating(this.protoTarget, stack) + counter.get().floatValue());
            if (!tool.equals("blank") && stack.method_7909().method_7841() == 0) {
                rating = 0.1;
            }
        }
        if (((PlayerEntityAccessor)this.player).getInventory().field_7545 == slot) {
            rating += 0.1;
        }
        double finalRating = rating;
        boolean finalStackEnchants = stackEnchants;
        AutoSwitch.logger.debug("Rating: {}; Slot: {}", (Object)rating, (Object)slot);
        this.slot2ToolRating.computeIfPresent(slot, (iSlot, oldRating) -> TargetableUtil.toolRatingChange(oldRating, finalRating, stack, finalStackEnchants));
        this.slot2ToolRating.putIfAbsent(slot, rating);
    }

    boolean checkSpecialCase(Object target) {
        return false;
    }

    @FunctionalInterface
    static interface TargetGetter {
        public Object getTarget(Object var1);
    }

    @FunctionalInterface
    static interface ToolSelector {
        public boolean correctType(String var1, class_1792 var2);
    }
}

