/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.targetable;

import autoswitch.AutoSwitch;
import autoswitch.config.AutoSwitchConfig;
import autoswitch.targetable.Targetable;
import autoswitch.util.TargetableUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2680;

class TargetableAttack
extends Targetable {
    public TargetableAttack(Object protoTarget, class_1657 player) {
        super(player);
        this.player = player;
        this.protoTarget = protoTarget;
        this.populateToolLists();
    }

    @Override
    void populateToolSelection(class_1799 stack, int slot) {
        this.processToolSelectors(stack, slot, AutoSwitch.switchData.target2AttackActionToolSelectorsMap, TargetableUtil::getAttackTarget, TargetableUtil::isCorrectAttackType);
    }

    @Override
    Boolean switchTypeAllowed() {
        if (AutoSwitch.featureCfg.switchAllowed() == AutoSwitchConfig.TargetType.BOTH) {
            return true;
        }
        if (this.protoTarget instanceof class_2680) {
            return AutoSwitch.featureCfg.switchAllowed() == AutoSwitchConfig.TargetType.BLOCKS;
        }
        if (this.protoTarget instanceof class_1297) {
            return AutoSwitch.featureCfg.switchAllowed() == AutoSwitchConfig.TargetType.MOBS;
        }
        AutoSwitch.logger.error("Something strange tried to trigger a switch...");
        return false;
    }

    @Override
    protected boolean checkSpecialCase(Object target) {
        return AutoSwitch.featureCfg.useNoDurabilityItemsWhenUnspecified() == false && AutoSwitch.switchData.target2AttackActionToolSelectorsMap.get(target) == null;
    }
}

