/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.util;

import autoswitch.AutoSwitch;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2846;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SwitchUtil {
    public static Consumer<Boolean> handleUseSwitchConsumer() {
        return moveToOffhand -> {
            if (moveToOffhand.booleanValue() && AutoSwitch.featureCfg.switchbackAllowed().allowed()) {
                AutoSwitch.switchState.setHasSwitched(true);
            }
            assert (class_310.method_1551().method_1562() != null) : "Minecraft client was null when AutoSwitch wanted to sent a packet!";
            if (moveToOffhand.booleanValue() && SwitchUtil.doPutActionOffhandCheck()) {
                class_310.method_1551().method_1562().method_2883((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033));
            }
        };
    }

    private static boolean doPutActionOffhandCheck() {
        assert (class_310.method_1551().field_1724 != null);
        return AutoSwitch.featureCfg.preserveOffhandItem() == false || class_310.method_1551().field_1724.method_6079() == class_1799.field_8037;
    }

    public static String getMinecraftVersion() {
        return SwitchUtil.getVersion("minecraft");
    }

    private static String getVersion(String modid) {
        Optional modContainer = FabricLoader.getInstance().getModContainer(modid);
        if (modContainer.isPresent()) {
            return ((ModContainer)modContainer.get()).getMetadata().getVersion().getFriendlyString();
        }
        AutoSwitch.logger.error("Could not find version for: {}", (Object)modid);
        return "";
    }

    public static String getAutoSwitchVersion() {
        return SwitchUtil.getVersion("autoswitch");
    }
}

