/*
 * Decompiled with CFR 0.152.
 */
package autoswitch.util;

import autoswitch.AutoSwitch;
import autoswitch.util.ItemTarget;
import autoswitch.util.SwitchState;
import autoswitch.util.TargetableCache;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_4970;
import net.minecraft.class_5134;

public class TargetableUtil {
    private static final int NONE = -1;

    public static double toolRatingChange(double oldValue, double newValue, class_1799 stack, boolean stackEnchant) {
        if (stackEnchant && AutoSwitch.featureCfg.toolEnchantmentsStack().booleanValue() && !stack.method_7909().equals(class_1799.field_8037.method_7909()) && stack.method_7936() != 0) {
            return oldValue + newValue;
        }
        return Math.max(oldValue, newValue);
    }

    public static Object getAttackTarget(Object protoTarget) {
        return TargetableUtil.getTarget(AutoSwitch.switchData.target2AttackActionToolSelectorsMap, protoTarget);
    }

    public static Object getUseTarget(Object protoTarget) {
        return TargetableUtil.getTarget(AutoSwitch.switchData.target2UseActionToolSelectorsMap, protoTarget);
    }

    private static Object getTarget(Object2ObjectOpenHashMap<Object, IntArrayList> map, Object protoTarget) {
        if (protoTarget instanceof ItemTarget) {
            return protoTarget;
        }
        if (protoTarget instanceof class_4970.class_4971) {
            if (map.containsKey((Object)((class_4970.class_4971)protoTarget).method_26204())) {
                return ((class_4970.class_4971)protoTarget).method_26204();
            }
            return ((class_4970.class_4971)protoTarget).method_26207();
        }
        if (protoTarget instanceof class_1297) {
            if (map.containsKey((Object)((class_1297)protoTarget).method_5864())) {
                return ((class_1297)protoTarget).method_5864();
            }
            if (protoTarget instanceof class_1309) {
                return ((class_1309)protoTarget).method_6046();
            }
            return ((class_1297)protoTarget).method_5864();
        }
        return null;
    }

    public static float getTargetRating(Object target, class_1799 stack) {
        if (target instanceof class_2680) {
            return TargetableUtil.clampToolRating(stack.method_7924((class_2680)target));
        }
        if (target instanceof class_1297) {
            if (!(stack.method_7909() instanceof class_1831)) {
                return 0.0f;
            }
            float h = 0.0f;
            AtomicReference<Float> baseDamage = new AtomicReference<Float>(Float.valueOf(0.0f));
            stack.method_7926(class_1304.field_6173).get((Object)class_5134.field_23721).forEach(entityAttributeModifier -> baseDamage.updateAndGet(v -> Float.valueOf((float)((double)v.floatValue() + entityAttributeModifier.method_6186()))));
            float damage = baseDamage.get().floatValue();
            if (AutoSwitch.featureCfg.weaponRatingIncludesEnchants().booleanValue()) {
                h = target instanceof class_1309 ? class_1890.method_8218((class_1799)stack, (class_1310)((class_1309)target).method_6046()) : class_1890.method_8218((class_1799)stack, (class_1310)class_1310.field_6290);
            }
            AtomicReference<Float> attackSpeed = new AtomicReference<Float>(Float.valueOf(0.0f));
            stack.method_7926(class_1304.field_6173).get((Object)class_5134.field_23723).forEach(entityAttributeModifier -> attackSpeed.updateAndGet(v -> Float.valueOf((float)((double)v.floatValue() + entityAttributeModifier.method_6186()))));
            return (damage += h) * (3.0f + attackSpeed.get().floatValue());
        }
        return 0.0f;
    }

    private static float clampToolRating(float original) {
        if (AutoSwitch.featureCfg.preferMinimumViableTool().booleanValue() && original > 0.0f) {
            return (float)(6.25 * Math.log10(original) / (double)original);
        }
        return original;
    }

    public static boolean skipSlot(class_1799 itemStack) {
        AutoSwitch.logger.debug("Stack: {}; First: {}; Second: {}", (Object)itemStack, (Object)(AutoSwitch.featureCfg.useNoDurabilityItemsWhenUnspecified() == false || itemStack.method_7963() ? 1 : 0), (Object)(TargetableUtil.isAlmostBroken(itemStack) && AutoSwitch.featureCfg.tryPreserveDamagedTools() != false ? 1 : 0));
        if (AutoSwitch.featureCfg.skipDepletedItems().booleanValue() && AutoSwitch.switchData.damageMap.containsKey(itemStack.method_7909().getClass()) && TargetableUtil.isAlmostBroken(itemStack)) {
            return true;
        }
        return (AutoSwitch.featureCfg.useNoDurabilityItemsWhenUnspecified() == false || itemStack.method_7963()) && TargetableUtil.isAlmostBroken(itemStack) && AutoSwitch.featureCfg.tryPreserveDamagedTools() != false;
    }

    private static boolean isAlmostBroken(class_1799 stack) {
        return TargetableUtil.getDurability(stack) <= 3 && TargetableUtil.getDurability(stack) != -1;
    }

    private static int getDurability(class_1799 stack) {
        AtomicReference<Integer> durability = new AtomicReference<Integer>(-1);
        if (stack.method_7963()) {
            return stack.method_7936() - stack.method_7919();
        }
        AutoSwitch.switchData.damageMap.forEach((clazz, durabilityGetter) -> {
            if (clazz.isInstance(stack.method_7909())) {
                durability.set((Integer)durabilityGetter.getDurability(stack));
            }
        });
        return ((Number)durability.get()).intValue();
    }

    public static OptionalInt getCachedSlot(Object target, SwitchState state, boolean isUseAction) {
        return TargetableUtil.getTargetableCache(state, isUseAction).containsKey(target) ? OptionalInt.of(TargetableUtil.getTargetableCache(state, isUseAction).getInt(target)) : OptionalInt.empty();
    }

    public static TargetableCache getTargetableCache(SwitchState state, boolean isUseAction) {
        if (isUseAction) {
            return state.switchInteractCache;
        }
        return state.switchActionCache;
    }

    public static boolean isRightTool(class_1799 stack, Object target) {
        if (!AutoSwitch.featureCfg.miningLevelCheck().booleanValue()) {
            return true;
        }
        if (AutoSwitch.featureCfg.useNoDurabilityItemsWhenUnspecified().booleanValue() && stack.method_7936() == 0) {
            return true;
        }
        if (target instanceof class_2680) {
            return !((class_2680)target).method_29291() || stack.method_7951((class_2680)target);
        }
        return true;
    }

    public static boolean isCorrectAttackType(String tool, class_1792 item) {
        return AutoSwitch.featureCfg.useNoDurabilityItemsWhenUnspecified() != false && item.method_7841() == 0 || TargetableUtil.isCorrectTool(tool, item);
    }

    public static boolean isCorrectUseType(String tool, class_1792 item) {
        return TargetableUtil.isCorrectTool(tool, item);
    }

    private static boolean isCorrectTool(String tool, class_1792 item) {
        AtomicBoolean matches = new AtomicBoolean(false);
        AutoSwitch.switchData.toolGroupings.forEach((toolKey, tagClassPair) -> {
            if ((tool.equals(toolKey) || tool.equals("any")) && TargetableUtil.checkTagAndClass((class_3494<class_1792>)((class_3494)tagClassPair.getLeft()), (Class)tagClassPair.getRight(), item)) {
                matches.set(true);
            }
        });
        return matches.get() || class_2378.field_11142.method_10221((Object)item).equals((Object)class_2960.method_12829((String)tool));
    }

    private static boolean checkTagAndClass(class_3494<class_1792> tag, Class<?> clazz, class_1792 item) {
        return tag != null && tag.method_15141((Object)item) || clazz != null && clazz.isInstance(item);
    }
}

