/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.client.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import net.flytre.biome_locator.client.ClientDataStorage;
import net.flytre.biome_locator.client.screen.BiomeEntry;
import net.flytre.biome_locator.client.screen.BiomeList;
import net.flytre.biome_locator.client.screen.BiomeStatDisplay;
import net.flytre.biome_locator.client.screen.SearchType;
import net.flytre.biome_locator.common.BiomeLocator;
import net.flytre.biome_locator.common.BiomeUtils;
import net.flytre.biome_locator.config.ServerConfig;
import net.flytre.biome_locator.network.SearchBiomeC2SPacket;
import net.flytre.flytre_lib.api.config.reference.BiomeReference;
import net.flytre.flytre_lib.api.gui.button.TranslucentButton;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class BiomeSelectionScreen
extends class_437 {
    public final class_1937 world;
    private final List<class_1959> validBiomes;
    private final List<class_1959> matchedBiomes;
    public SearchType searchType;
    private TranslucentButton searchButton;
    private TranslucentButton infoButton;
    private TranslucentButton modeButton;
    private class_342 searchField;
    private BiomeList selectionList;

    public BiomeSelectionScreen(class_1937 world) {
        super((class_2561)new class_2588("item.biome_locator.compass"));
        this.world = world;
        this.validBiomes = BiomeUtils.getAllBiomes(world).stream().filter(i -> !new BiomeReference(i, world).isIn(((ServerConfig)BiomeLocator.CONFIG.getConfig()).blacklistedBiomes)).collect(Collectors.toList());
        this.matchedBiomes = new ArrayList<class_1959>(this.validBiomes);
        this.searchType = SearchType.NAME;
    }

    public void search(class_1959 biome) {
        class_310.method_1551().method_1562().method_2883((class_2596)new SearchBiomeC2SPacket(BiomeUtils.getId(biome, this.world)));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.selectionList.method_25394(matrices, mouseX, mouseY, delta);
        this.searchField.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean superValue = super.method_25404(keyCode, scanCode, modifiers);
        if (this.searchField.method_25370()) {
            this.updateSearch();
            return true;
        }
        return superValue;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        boolean superValue = super.method_25400(typedChar, keyCode);
        if (this.searchField.method_25370()) {
            this.updateSearch();
            return true;
        }
        return superValue;
    }

    public void method_25419() {
        super.method_25419();
        assert (this.field_22787 != null);
        this.field_22787.field_1774.method_1462(false);
    }

    public void select(BiomeEntry entry) {
        this.searchButton.field_22763 = entry != null;
        this.infoButton.field_22763 = entry != null && this.modeButton.field_22763;
    }

    public boolean method_25421() {
        return false;
    }

    public void updateSearch() {
        this.matchedBiomes.clear();
        if (this.searchType == SearchType.NAME) {
            this.validBiomes.stream().filter(biome -> BiomeUtils.getBiomeName(biome, this.world).toLowerCase().contains(this.searchField.method_1882().toLowerCase())).forEach(this.matchedBiomes::add);
        } else if (this.searchType == SearchType.RESOURCE) {
            this.validBiomes.stream().filter(biome -> ClientDataStorage.hasResource(this.searchField.method_1882().toLowerCase(), biome, this.world)).forEach(this.matchedBiomes::add);
        }
        this.selectionList.refreshList();
    }

    public String getSearch() {
        return this.searchField.method_1882();
    }

    public List<class_1959> sort() {
        List<class_1959> biomes = this.matchedBiomes;
        biomes.sort(Comparator.comparing(biome -> BiomeUtils.getBiomeName(biome, this.world)));
        return biomes;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.selectionList.method_25401(mouseX, mouseY, amount);
    }

    public void method_25393() {
        this.searchField.method_1865();
        this.modeButton.field_22763 = ClientDataStorage.blocks.size() > 0 || ClientDataStorage.mobs.size() > 0;
    }

    protected void method_25426() {
        assert (this.field_22787 != null);
        this.field_22787.field_1774.method_1462(true);
        ArrayList toRemove = new ArrayList();
        this.method_25396().forEach(i -> {
            if (i instanceof AbstractButton) {
                toRemove.add(i);
            }
        });
        toRemove.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.method_37063((class_364)new TranslucentButton(10, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("gui.cancel"), onPress -> this.field_22787.method_1507(null)));
        this.searchButton = (TranslucentButton)this.method_37063((class_364)new TranslucentButton(this.field_22789 - 140, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("gui.biome_locator.search"), onPress -> {
            if (this.selectionList.hasSelection()) {
                class_1959 biome = Objects.requireNonNull((BiomeEntry)this.selectionList.method_25334()).getBiome();
                if (biome != null) {
                    this.search(biome);
                }
                this.field_22787.method_1507(null);
            }
        }));
        this.infoButton = (TranslucentButton)this.method_37063((class_364)new TranslucentButton(this.field_22789 - 140, this.field_22790 - 60, 110, 20, (class_2561)new class_2588("gui.biome_locator.info"), onPress -> {
            if (this.selectionList.hasSelection()) {
                class_310.method_1551().method_1507((class_437)new BiomeStatDisplay(this, Objects.requireNonNull((BiomeEntry)this.selectionList.method_25334()).getBiome()));
            }
        }));
        this.modeButton = (TranslucentButton)this.method_37063((class_364)new TranslucentButton(10, this.field_22790 - 60, 110, 20, (class_2561)new class_2588(this.searchType == SearchType.NAME ? "gui.biome_locator.searchType.name" : "gui.biome_locator.searchType.resource"), onPress -> {
            if (this.searchType == SearchType.NAME) {
                this.searchType = SearchType.RESOURCE;
                onPress.method_25355((class_2561)new class_2588("gui.biome_locator.searchType.resource"));
            } else {
                this.searchType = SearchType.NAME;
                onPress.method_25355((class_2561)new class_2588("gui.biome_locator.searchType.name"));
            }
            this.updateSearch();
        }));
        this.searchButton.field_22763 = false;
        this.infoButton.field_22763 = false;
        this.searchField = new class_342(this.field_22793, (this.field_22789 - 140) / 2, 10, 140, 20, (class_2561)new class_2588("gui.biome_locator.search"));
        this.method_25429((class_364)this.searchField);
        if (this.selectionList == null) {
            this.selectionList = new BiomeList(this, this.field_22787, this.field_22789, this.field_22790, 60, this.field_22790 - 20, 50);
        }
        this.method_25429((class_364)this.selectionList);
        this.selectionList.refreshList();
        super.method_25426();
    }
}

