/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import net.flytre.biome_locator.client.ClientDataStorage;
import net.flytre.biome_locator.client.screen.BiomeStatDisplay;
import net.flytre.biome_locator.client.screen.StringList;
import net.flytre.biome_locator.common.BiomeUtils;
import net.flytre.flytre_lib.api.gui.button.TranslucentButton;
import net.minecraft.class_1074;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class BiomeStatDisplay2
extends class_437 {
    private final BiomeStatDisplay page1;
    private final List<String> mobs;
    private final List<String> resources;
    private final class_1959 biome;
    private StringList mobList;
    private StringList resourceList;

    public BiomeStatDisplay2(BiomeStatDisplay page1) {
        super((class_2561)new class_2585(class_1074.method_4662((String)BiomeUtils.getBiomeName(page1.getBiome(), page1.getSelectionScreen().world), (Object[])new Object[0])));
        this.biome = page1.getBiome();
        this.page1 = page1;
        class_2960 id = BiomeUtils.getId(this.biome, page1.getSelectionScreen().world);
        if (!page1.isRabbit()) {
            this.mobs = new ArrayList(ClientDataStorage.mobs.get(id)).stream().map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).distinct().collect(Collectors.toList());
            this.resources = new ArrayList(ClientDataStorage.blocks.get(id)).stream().map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).distinct().collect(Collectors.toList());
        } else {
            this.mobs = new ArrayList<String>(Collections.singleton("entity.minecraft.rabbit")).stream().map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).distinct().collect(Collectors.toList());
            this.resources = new ArrayList<String>(Collections.singleton("block.biome_locator.rabbit_ore")).stream().map(x$0 -> class_1074.method_4662((String)x$0, (Object[])new Object[0])).distinct().collect(Collectors.toList());
        }
        Collections.sort(this.mobs);
        Collections.sort(this.resources);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        this.drawCenteredText(matrixStack, (class_2561)(this.page1.isRabbit() ? new class_2588("biome.biome_locator.rabbit_land") : new class_2585(BiomeUtils.getBiomeName(this.biome, this.page1.getSelectionScreen().world))), 0.5f, 20, 0xFFFFFF);
        this.drawCenteredText(matrixStack, (class_2561)new class_2588("gui.biome_locator.mobs"), 0.25f, 40, 0xFFFFFF);
        this.drawCenteredText(matrixStack, (class_2561)new class_2588("gui.biome_locator.resources"), 0.75f, 40, 0xFFFFFF);
        this.mobList.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.resourceList.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        this.mobList.method_25401(mouseX, mouseY, amount);
        this.resourceList.method_25401(mouseX, mouseY, amount);
        return true;
    }

    private void drawCenteredText(class_4587 matrixStack, class_2561 text, float percent, int y, int color) {
        float baseX = (float)this.field_22789 / (1.0f / percent);
        this.field_22793.method_30883(matrixStack, text, baseX - (float)this.field_22793.method_27525((class_5348)text) / 2.0f, (float)y, color);
    }

    public void method_25426() {
        ArrayList toRemove = new ArrayList();
        this.method_25396().forEach(i -> {
            if (i instanceof AbstractButton) {
                toRemove.add(i);
            }
        });
        toRemove.forEach(x$0 -> this.method_37066((class_364)x$0));
        this.method_37063((class_364)new TranslucentButton(10, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("gui.biome_locator.previous"), onPress -> class_310.method_1551().method_1507((class_437)this.page1)));
        this.method_37063((class_364)new TranslucentButton(this.field_22789 - 120, this.field_22790 - 30, 110, 20, (class_2561)new class_2588("gui.biome_locator.search"), onPress -> {
            this.page1.getSelectionScreen().search(this.biome);
            assert (this.field_22787 != null);
            this.field_22787.method_1507(null);
        }));
        if (this.mobList == null) {
            this.mobList = new StringList(this.field_22787, this.field_22789, this.field_22790, 60, this.field_22790 - 60, 12, 0.25f);
        }
        this.mobList.populate(this.mobs);
        if (this.resourceList == null) {
            this.resourceList = new StringList(this.field_22787, this.field_22789, this.field_22790, 60, this.field_22790 - 60, 12, 0.75f);
        }
        this.resourceList.populate(this.resources);
    }
}

