/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.config;

import com.google.gson.annotations.SerializedName;
import java.util.Set;
import net.flytre.flytre_lib.api.config.annotation.Description;
import net.flytre.flytre_lib.api.config.annotation.DisplayName;
import net.flytre.flytre_lib.api.config.annotation.Range;
import net.flytre.flytre_lib.api.config.network.SyncedConfig;
import net.flytre.flytre_lib.api.config.reference.AdvancementReference;
import net.flytre.flytre_lib.api.config.reference.BiomeReference;

@DisplayName(value="config.biome_locator.server")
public class ServerConfig
implements SyncedConfig {
    @Range(min=0.0, max=25600.0)
    @Description(value="The farthest distance the biome locator will look to try and find the target biome")
    @SerializedName(value="max_biome_distance")
    public int maxBiomeDistance = 6400;
    @Description(value="Use the /advancement command for help with advancement ids")
    @SerializedName(value="required_advancement")
    public AdvancementReference requiredAdvancement = new AdvancementReference("minecraft", "none");
    @Range(min=0.0, max=1.0)
    @Description(value="The chance of the biome locator appearing in loot chests")
    @SerializedName(value="chance_as_loot")
    public float chanceAsLoot = 0.16f;
    @Description(value="The list of biomes that are hidden from the biome locator")
    @SerializedName(value="blacklisted_biomes")
    public Set<BiomeReference> blacklistedBiomes = Set.of(new BiomeReference("appliedenergistics2", "spatial_storage"));
}

