/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.biome_locator.server;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.flytre.biome_locator.common.BiomeUtils;
import net.flytre.biome_locator.mixin.WeightedBlockStateProviderAccessor;
import net.flytre.biome_locator.network.GiantBiomeS2CPacket;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2942;
import net.minecraft.class_2954;
import net.minecraft.class_2960;
import net.minecraft.class_2964;
import net.minecraft.class_2975;
import net.minecraft.class_2978;
import net.minecraft.class_2986;
import net.minecraft.class_3026;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3047;
import net.minecraft.class_3070;
import net.minecraft.class_3081;
import net.minecraft.class_3160;
import net.minecraft.class_3168;
import net.minecraft.class_3183;
import net.minecraft.class_3219;
import net.minecraft.class_3222;
import net.minecraft.class_3310;
import net.minecraft.class_3481;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_4779;
import net.minecraft.class_4784;
import net.minecraft.class_5483;
import net.minecraft.class_6005;
import org.jetbrains.annotations.Nullable;

public class ServerBiomeDataProcessor {
    public static final Random RANDOM = new Random();
    private static Cache cache = null;

    public static void sendDataToClient(class_3222 player, class_1937 world) {
        ServerBiomeDataProcessor.cacheAll(world);
        GiantBiomeS2CPacket infoPacket = new GiantBiomeS2CPacket(ServerBiomeDataProcessor.cache.mobs, ServerBiomeDataProcessor.cache.blocks);
        player.field_13987.method_14364((class_2596)infoPacket);
    }

    private static void cacheAll(class_1937 world) {
        if (cache == null) {
            HashMap<class_2960, Set<String>> mobs = new HashMap<class_2960, Set<String>>();
            HashMap<class_2960, Set<String>> blocks = new HashMap<class_2960, Set<String>>();
            for (class_1959 biome : BiomeUtils.getAllBiomes(world)) {
                mobs.put(BiomeUtils.getId(biome, world), ServerBiomeDataProcessor.getMobSpawns(biome));
                blocks.put(BiomeUtils.getId(biome, world), ServerBiomeDataProcessor.getMiscResources(biome));
            }
            cache = new Cache(mobs, blocks);
        }
    }

    public static Set<String> getMobSpawns(class_1959 biome) {
        HashSet<String> result = new HashSet<String>();
        class_5483 spawnSettings = biome.method_30966();
        for (class_1311 group : class_1311.values()) {
            for (class_5483.class_1964 spawnEntry : spawnSettings.method_31004(group).method_34994()) {
                result.add(ServerBiomeDataProcessor.translateKey("entity", class_2378.field_11145.method_10221((Object)spawnEntry.field_9389)));
            }
        }
        return result;
    }

    private static String translateKey(String type, class_2960 id) {
        return class_156.method_646((String)type, (class_2960)id);
    }

    private static Set<String> sampleProvider(class_4651 provider) {
        HashSet<String> result = new HashSet<String>();
        if (provider instanceof class_4657) {
            class_4657 weighted = (class_4657)provider;
            class_6005<class_2680> states = ((WeightedBlockStateProviderAccessor)weighted).getList();
            states.method_34994().forEach(i -> result.add(((class_2680)i.method_34983()).method_26204().method_9539()));
            return result;
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            class_2680 state = provider.method_23455(RANDOM, new class_2338(RANDOM.nextInt(10000), RANDOM.nextInt(10000), RANDOM.nextInt(10000)));
            result.add(state.method_26204().method_9539());
        }
        return result;
    }

    public static Set<String> getMiscResources(class_1959 biome) {
        HashSet<String> result = new HashSet<String>();
        for (List list : biome.method_30970().method_30983()) {
            for (Supplier feature : list) {
                class_3037 config = ServerBiomeDataProcessor.getConfig((class_2975)feature.get());
                result.addAll(ServerBiomeDataProcessor.getHardcodedResources(biome, ServerBiomeDataProcessor.getFeature((class_2975)feature.get())));
                if (config == null) continue;
                for (Field field : ServerBiomeDataProcessor.getFields(config)) {
                    try {
                        if (field.getType().isAssignableFrom(class_4651.class)) {
                            field.setAccessible(true);
                            class_4651 provider = (class_4651)field.get(config);
                            result.addAll(ServerBiomeDataProcessor.sampleProvider(provider));
                            continue;
                        }
                        if (!field.getType().isAssignableFrom(class_2680.class)) continue;
                        field.setAccessible(true);
                        class_2680 state = (class_2680)field.get(config);
                        result.add(state.method_26204().method_9539());
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    @Nullable
    private static class_3037 getConfig(class_2975<?, ?> feature) {
        while (feature.field_13375 instanceof class_2986) {
            feature = (class_2975)((class_2986)feature.field_13375).field_13399.get();
        }
        if (feature.field_13375 instanceof class_3037) {
            return feature.field_13375;
        }
        return null;
    }

    @Nullable
    private static class_3031<?> getFeature(class_2975<?, ?> feature) {
        while (feature.field_13375 instanceof class_2986) {
            feature = (class_2975)((class_2986)feature.field_13375).field_13399.get();
        }
        if (feature.field_13376 instanceof class_3031) {
            return feature.field_13376;
        }
        return null;
    }

    private static <T> List<Field> getFields(T t) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    private static Set<String> getHardcodedResources(class_1959 biome, class_3031<?> feature) {
        HashSet<class_2248> states = new HashSet<class_2248>();
        if (feature instanceof class_2942) {
            states.add(class_2246.field_10211);
            states.add(class_2246.field_10520);
        }
        if (feature instanceof class_4779) {
            states.add(class_2246.field_22091);
        }
        if (feature instanceof class_2954) {
            states.add(class_2246.field_10384);
        }
        if (feature instanceof class_2964) {
            states.add(class_2246.field_10021);
        }
        if (feature instanceof class_2978) {
            states.addAll(class_3481.field_15461.method_15138());
        }
        if (feature instanceof class_3026) {
            states.add(class_2246.field_10471);
        }
        if (feature instanceof class_3310) {
            states.add(class_2246.field_10540);
        }
        if (feature instanceof class_3183 && (double)biome.method_8712() <= 0.15) {
            states.add(class_2246.field_10295);
            states.add(class_2246.field_10477);
        }
        if (feature instanceof class_3047) {
            states.add(class_2246.field_10171);
        }
        if (feature instanceof class_3070) {
            states.add(class_2246.field_10225);
        }
        if (feature instanceof class_3081) {
            states.add(class_2246.field_9993);
            states.add(class_2246.field_10463);
        }
        if (feature instanceof class_3168) {
            states.add(class_2246.field_10376);
            states.add(class_2246.field_10238);
        }
        if (feature instanceof class_3160) {
            states.add(class_2246.field_10476);
        }
        if (feature instanceof class_3219) {
            states.add(class_2246.field_10597);
        }
        if (feature instanceof class_4784) {
            states.add(class_2246.field_22123);
            states.add(class_2246.field_10541);
        }
        return states.stream().map(class_2248::method_9539).collect(Collectors.toSet());
    }

    private record Cache(Map<class_2960, Set<String>> mobs, Map<class_2960, Set<String>> blocks) {
    }
}

