/*
 * Decompiled with CFR 0.152.
 */
package me.deadlymc.damagetint.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.deadlymc.damagetint.TintConfig;
import me.deadlymc.damagetint.commands.ClientCommandManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;

public class TintCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tint").executes(TintCommand::status)).then(Commands.m_82129_((String)"health", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).suggests((c, b) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"0", "10", "20"}, (SuggestionsBuilder)b)).executes(c -> TintCommand.changeThreshold(FloatArgumentType.getFloat((CommandContext)c, (String)"health"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dynamic").executes(TintCommand::dynamic_status)).then(Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(c -> TintCommand.dynamic(BoolArgumentType.getBool((CommandContext)c, (String)"value")))))).then(Commands.m_82127_((String)"reset").executes(TintCommand::reset));
        dispatcher.register(command);
    }

    private static int status(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean dynamic = TintConfig.instance().isDynamic();
        float maxHealth = ((Player)((CommandSourceStack)context.getSource()).m_81374_()).m_21233_();
        float thresholdHealth = TintConfig.instance().getHealth();
        ClientCommandManager.sendFeedback((Component)new TextComponent(ChatFormatting.GRAY + "Predefined health threshold = " + ChatFormatting.RED + ChatFormatting.BOLD + thresholdHealth + " hp (" + thresholdHealth / 2.0f + " hearts)" + ChatFormatting.GRAY + "."));
        if (dynamic) {
            ClientCommandManager.sendFeedback((Component)new TextComponent(ChatFormatting.GRAY + "Current health threshold = " + ChatFormatting.RED + ChatFormatting.BOLD + maxHealth + " hp (" + maxHealth / 2.0f + " hearts)" + ChatFormatting.GRAY + "."));
        }
        ClientCommandManager.sendFeedback((Component)new TextComponent(dynamic ? ChatFormatting.GRAY + "Health threshold is updating dynamically! (Ignoring predefined value)" : ChatFormatting.GRAY + "Health threshold is not updating dynamically! (Using predefined value)"));
        return 0;
    }

    private static int changeThreshold(float health) {
        TintConfig.instance().update(health, false);
        ClientCommandManager.sendFeedback((Component)new TextComponent(ChatFormatting.GRAY + "Gradually tint screen at " + ChatFormatting.RED + ChatFormatting.BOLD + health + " hp (" + health / 2.0f + " hearts)" + ChatFormatting.GRAY + "."));
        return 0;
    }

    private static int dynamic_status(CommandContext<CommandSourceStack> context) {
        boolean dynamic = TintConfig.instance().isDynamic();
        ClientCommandManager.sendFeedback((Component)new TextComponent(dynamic ? ChatFormatting.GRAY + "Health threshold is updating dynamically! (Ignoring predefined value)" : ChatFormatting.GRAY + "Health threshold is not updating dynamically! (Using predefined value)"));
        return 0;
    }

    private static int dynamic(boolean dynamic) {
        TintConfig.instance().dynamic(dynamic);
        Object msg = "";
        if (TintConfig.instance().isDynamic()) {
            msg = ChatFormatting.GRAY + "Health threshold will update dynamically!";
        } else {
            float health = TintConfig.instance().getHealth();
            msg = ChatFormatting.GRAY + "Health threshold will not update dynamically! Using predefined health threshold = " + ChatFormatting.RED + ChatFormatting.BOLD + health + " hp (" + health / 2.0f + " hearts)" + ChatFormatting.GRAY + ".";
        }
        ClientCommandManager.sendFeedback((Component)new TextComponent((String)msg));
        return 0;
    }

    private static int reset(CommandContext<CommandSourceStack> context) {
        TintConfig.instance().update(20.0f, true);
        ClientCommandManager.sendFeedback((Component)new TextComponent(ChatFormatting.GRAY + "Reset all configs to default."));
        return 0;
    }
}

