/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.death_info.properties;

import com.glisco.deathlog.death_info.DeathInfoPropertyType;
import com.glisco.deathlog.death_info.RestorableDeathInfoProperty;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_3222;

public class ScoreProperty
implements RestorableDeathInfoProperty {
    private final int score;
    private final int levels;
    private final float progress;
    private final int xp;

    public ScoreProperty(int score, int level, float progress, int xp) {
        this.score = score;
        this.levels = level;
        this.progress = progress;
        this.xp = xp;
    }

    @Override
    public DeathInfoPropertyType<?> getType() {
        return Type.INSTANCE;
    }

    @Override
    public class_2561 formatted() {
        return new class_2585(this.score + " \u00a77(" + this.levels + " levels, " + this.xp + " xp)");
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("Score", this.score);
        nbt.method_10569("Levels", this.levels);
        nbt.method_10548("Progress", this.progress);
        nbt.method_10569("XP", this.xp);
    }

    @Override
    public String toSearchableString() {
        return this.xp + " " + this.levels;
    }

    @Override
    public void restore(class_3222 player) {
        player.field_7510 = this.progress;
        player.method_14252(this.levels);
    }

    public static class Type
    extends DeathInfoPropertyType<ScoreProperty> {
        public static final Type INSTANCE = new Type();

        private Type() {
            super("deathlog.deathinfoproperty.score", "score");
        }

        @Override
        public boolean displayedInInfoView() {
            return true;
        }

        @Override
        public ScoreProperty readFromNbt(class_2487 nbt) {
            int score = nbt.method_10550("Score");
            int levels = nbt.method_10550("Levels");
            float progress = nbt.method_10583("Progress");
            int xp = nbt.method_10550("XP");
            return new ScoreProperty(score, levels, progress, xp);
        }
    }
}

