/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.network;

import com.glisco.deathlog.DeathLogCommon;
import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.client.DeathLogClient;
import com.glisco.deathlog.network.RemoteDeathLogStorage;
import com.glisco.deathlog.server.DeathLogServer;
import com.glisco.deathlog.storage.BaseDeathLogStorage;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public class DeathLogPackets {

    public static class Server {
        public static final class_2960 OPEN_SCREEN_ID = new class_2960("deathlog", "open_screen");

        public static void registerDedicatedListeners() {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)Client.REQUEST_DELETION_ID, Server::handleDelete);
        }

        public static void registerCommonListeners() {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)Client.REQUEST_RESTORE_ID, Server::handleRestore);
        }

        private static void handleRestore(MinecraftServer minecraftServer, class_3222 player, class_3244 serverPlayNetworkHandler, class_2540 byteBuf, PacketSender packetSender) {
            UUID profileId = byteBuf.method_10790();
            int index = byteBuf.method_10816();
            minecraftServer.execute(() -> {
                if (!player.method_5687(4)) {
                    BaseDeathLogStorage.LOGGER.warn("Received unauthorized restore packet");
                    return;
                }
                class_3222 targetPlayer = minecraftServer.method_3760().method_14602(profileId);
                if (targetPlayer == null) {
                    BaseDeathLogStorage.LOGGER.warn("Received restore packet for invalid player");
                    return;
                }
                DeathLogCommon.getStorage().getDeathInfoList(profileId).get(index).restore(targetPlayer);
            });
        }

        private static void handleDelete(MinecraftServer minecraftServer, class_3222 player, class_3244 serverPlayNetworkHandler, class_2540 byteBuf, PacketSender packetSender) {
            UUID profileId = byteBuf.method_10790();
            int index = byteBuf.method_10816();
            minecraftServer.execute(() -> DeathLogServer.getStorage().delete(DeathLogServer.getStorage().getDeathInfoList(profileId).get(index), profileId));
        }

        public static void openScreen(UUID profileId, class_3222 target) {
            class_2540 buffer = PacketByteBufs.create();
            List<DeathInfo> infos = DeathLogServer.getStorage().getDeathInfoList(profileId);
            buffer.method_34062(infos, (packetByteBuf, info) -> info.write((class_2540)packetByteBuf));
            buffer.method_10797(profileId);
            buffer.writeBoolean(target.method_5682().method_3760().method_14602(profileId) != null);
            ServerPlayNetworking.send((class_3222)target, (class_2960)OPEN_SCREEN_ID, (class_2540)buffer);
        }
    }

    public static class Client {
        public static final class_2960 REQUEST_DELETION_ID = new class_2960("deathlog", "request_deletion");
        public static final class_2960 REQUEST_RESTORE_ID = new class_2960("deathlog", "request_restore");

        public static void registerListeners() {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)Server.OPEN_SCREEN_ID, Client::handleOpenScreen);
        }

        private static void handleOpenScreen(class_310 minecraftClient, class_634 clientPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
            RemoteDeathLogStorage storage = RemoteDeathLogStorage.read(packetByteBuf);
            boolean canRestore = packetByteBuf.readBoolean();
            minecraftClient.execute(() -> DeathLogClient.openScreen(storage, canRestore));
        }

        public static void requestDeletion(UUID profile, int index) {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10797(profile);
            buffer.method_10804(index);
            ClientPlayNetworking.send((class_2960)REQUEST_DELETION_ID, (class_2540)buffer);
        }

        public static void requestRestore(UUID profile, int index) {
            class_2540 buffer = PacketByteBufs.create();
            buffer.method_10797(profile);
            buffer.method_10804(index);
            ClientPlayNetworking.send((class_2960)REQUEST_RESTORE_ID, (class_2540)buffer);
        }
    }
}

