/*
 * Decompiled with CFR 0.152.
 */
package net.dehydration.block;

import java.util.Map;
import java.util.function.Predicate;
import net.dehydration.block.AbstractCopperCauldronBlock;
import net.dehydration.block.CopperCauldronBlock;
import net.dehydration.block.entity.CopperCauldronBehavior;
import net.dehydration.init.BlockInit;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;

public class CopperLeveledCauldronBlock
extends AbstractCopperCauldronBlock {
    public static final int field_31107 = 1;
    public static final int field_31108 = 3;
    public static final class_2758 LEVEL = class_2741.field_12513;
    public static final Predicate<class_1959.class_1963> RAIN_PREDICATE = precipitation -> precipitation == class_1959.class_1963.field_9382;
    public static final Predicate<class_1959.class_1963> SNOW_PREDICATE = precipitation -> precipitation == class_1959.class_1963.field_9383;
    private final Predicate<class_1959.class_1963> precipitationPredicate;

    public CopperLeveledCauldronBlock(class_4970.class_2251 settings, Predicate<class_1959.class_1963> precipitationPredicate, Map<class_1792, CopperCauldronBehavior> behaviorMap) {
        super(settings, behaviorMap);
        this.precipitationPredicate = precipitationPredicate;
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(1)));
    }

    @Override
    public boolean isFull(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 3;
    }

    @Override
    protected boolean canBeFilledByDripstone(class_3611 fluid) {
        return fluid == class_3612.field_15910 && this.precipitationPredicate == RAIN_PREDICATE;
    }

    @Override
    protected double getFluidHeight(class_2680 state) {
        return (6.0 + (double)((Integer)state.method_11654((class_2769)LEVEL)).intValue() * 3.0) / 16.0;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (!world.field_9236 && entity.method_5809() && this.isEntityTouchingFluid(state, pos, entity)) {
            entity.method_5646();
            if (entity.method_36971(world, pos)) {
                this.onFireCollision(state, world, pos);
            }
        }
    }

    protected void onFireCollision(class_2680 state, class_1937 world, class_2338 pos) {
        CopperLeveledCauldronBlock.decrementFluidLevel(state, world, pos);
    }

    public static void decrementFluidLevel(class_2680 state, class_1937 world, class_2338 pos) {
        int i = (Integer)state.method_11654((class_2769)LEVEL) - 1;
        world.method_8501(pos, i == 0 ? BlockInit.COPPER_CAULDRON_BLOCK.method_9564() : (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(i)));
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        if (CopperCauldronBlock.canFillWithPrecipitation(world, precipitation) && (Integer)state.method_11654((class_2769)LEVEL) != 3 && this.precipitationPredicate.test(precipitation)) {
            world.method_8501(pos, (class_2680)state.method_28493((class_2769)LEVEL));
        }
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)LEVEL);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
    }

    @Override
    protected void fillFromDripstone(class_2680 state, class_1937 world, class_2338 pos, class_3611 fluid) {
        if (!this.isFull(state)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) + 1)));
            world.method_20290(1047, pos, 0);
        }
    }
}

